-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 设置测试类型
local ipmi = require 'manufacture.ipmi.cmds.SetTestType'
local mc_ipmi = require 'ipmi'
local db = require 'db_singleton'
local cc = mc_ipmi.types.Cc

local TEST_TYPE = {
    [0] = 'bios_mem_aging_test',
    [1] = 'manufacture_test'
}

local ipmi_handler = {}

function ipmi_handler.set_test_type(req, ctx)
    local test_type = TEST_TYPE[req.TestType]
    if not test_type then
        mc_ipmi.ipmi_operation_log(ctx, 'manufacture', "Set test type failed")
        return ipmi.SetTestTypeRsp.new(cc.InvalidCommand)
    end

    local test_type_table = db.get_instance():get_db().TestType({Id = test_type})

    if not test_type_table then
        mc_ipmi.ipmi_operation_log(ctx, 'manufacture', "Set test type failed")
        return ipmi.SetTestTypeRsp.new(cc.InvalidCommand)
    end

    test_type_table.TestFlag = req.Open
    test_type_table.TestType = req.Param
    test_type_table:save()
    mc_ipmi.ipmi_operation_log(ctx, 'manufacture',
        "Set test type(%s) to (0x%x) successfully", test_type, req.Param)
    return ipmi.SetTestTypeRsp.new(cc.Success)
end

return ipmi_handler