-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 设置测试类型
local ipmi = require 'manufacture.ipmi.cmds.GetTestType'
local mc_ipmi = require 'ipmi'
local log = require 'mc.logging'
local db = require 'db_singleton'
local cc = mc_ipmi.types.Cc

local TEST_TYPE = {
    [0] = 'bios_mem_aging_test',
    [1] = 'manufacture_test'
}

local ipmi_handler = {}
function ipmi_handler.get_test_type(req, ctx)
    local test_type = TEST_TYPE[req.TestType]

    if not test_type then
        return ipmi.GetTestTypeRsp.new(cc.InvalidCommand, 0, 0)
    end

    local test_type_table = db.get_instance():get_db().TestType({Id = test_type})
    if not test_type_table then
        log:error('test_type_table is nil')
        return ipmi.GetTestTypeRsp.new(cc.InvalidCommand, 0, 0)
    end
    return ipmi.GetTestTypeRsp.new(cc.Success, test_type_table.TestFlag, test_type_table.TestType)
end

return ipmi_handler