-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ManagerVersion = {}

---@class ManagerVersion.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj ManagerVersion.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', true, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

ManagerVersion.Version = TVersion

---@class ManagerVersion.MinorVersion
---@field MinorVersion string
local TMinorVersion = {}
TMinorVersion.__index = TMinorVersion
TMinorVersion.group = {}

local function TMinorVersion_from_obj(obj)
    return setmetatable(obj, TMinorVersion)
end

function TMinorVersion.new(MinorVersion)
    return TMinorVersion_from_obj({MinorVersion = MinorVersion})
end
---@param obj ManagerVersion.MinorVersion
function TMinorVersion:init_from_obj(obj)
    self.MinorVersion = obj.MinorVersion
end

function TMinorVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinorVersion.group)
end

TMinorVersion.from_obj = TMinorVersion_from_obj

TMinorVersion.proto_property = {'MinorVersion'}

TMinorVersion.default = {''}

TMinorVersion.struct = {{name = 'MinorVersion', is_array = false, struct = nil}}

function TMinorVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinorVersion', self.MinorVersion, 'string', true, errs, need_convert)

    TMinorVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinorVersion.proto_property, errs, need_convert)
    return self
end

function TMinorVersion:unpack(_)
    return self.MinorVersion
end

ManagerVersion.MinorVersion = TMinorVersion

---@class ManagerVersion.MajorVersion
---@field MajorVersion string
local TMajorVersion = {}
TMajorVersion.__index = TMajorVersion
TMajorVersion.group = {}

local function TMajorVersion_from_obj(obj)
    return setmetatable(obj, TMajorVersion)
end

function TMajorVersion.new(MajorVersion)
    return TMajorVersion_from_obj({MajorVersion = MajorVersion})
end
---@param obj ManagerVersion.MajorVersion
function TMajorVersion:init_from_obj(obj)
    self.MajorVersion = obj.MajorVersion
end

function TMajorVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMajorVersion.group)
end

TMajorVersion.from_obj = TMajorVersion_from_obj

TMajorVersion.proto_property = {'MajorVersion'}

TMajorVersion.default = {''}

TMajorVersion.struct = {{name = 'MajorVersion', is_array = false, struct = nil}}

function TMajorVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MajorVersion', self.MajorVersion, 'string', true, errs, need_convert)

    TMajorVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMajorVersion.proto_property, errs, need_convert)
    return self
end

function TMajorVersion:unpack(_)
    return self.MajorVersion
end

ManagerVersion.MajorVersion = TMajorVersion

---@class ManagerVersion.PlatformMajorVersion
---@field PlatformMajorVersion string
local TPlatformMajorVersion = {}
TPlatformMajorVersion.__index = TPlatformMajorVersion
TPlatformMajorVersion.group = {}

local function TPlatformMajorVersion_from_obj(obj)
    return setmetatable(obj, TPlatformMajorVersion)
end

function TPlatformMajorVersion.new(PlatformMajorVersion)
    return TPlatformMajorVersion_from_obj({PlatformMajorVersion = PlatformMajorVersion})
end
---@param obj ManagerVersion.PlatformMajorVersion
function TPlatformMajorVersion:init_from_obj(obj)
    self.PlatformMajorVersion = obj.PlatformMajorVersion
end

function TPlatformMajorVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPlatformMajorVersion.group)
end

TPlatformMajorVersion.from_obj = TPlatformMajorVersion_from_obj

TPlatformMajorVersion.proto_property = {'PlatformMajorVersion'}

TPlatformMajorVersion.default = {''}

TPlatformMajorVersion.struct = {{name = 'PlatformMajorVersion', is_array = false, struct = nil}}

function TPlatformMajorVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PlatformMajorVersion', self.PlatformMajorVersion, 'string', true, errs, need_convert)

    TPlatformMajorVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPlatformMajorVersion.proto_property, errs, need_convert)
    return self
end

function TPlatformMajorVersion:unpack(_)
    return self.PlatformMajorVersion
end

ManagerVersion.PlatformMajorVersion = TPlatformMajorVersion

---@class ManagerVersion.GetReleaseVersionRsp
---@field ActiveReleaseVersion string
---@field BackupReleaseVersion string
---@field AvailableReleaseVersion string
local TGetReleaseVersionRsp = {}
TGetReleaseVersionRsp.__index = TGetReleaseVersionRsp
TGetReleaseVersionRsp.group = {}

local function TGetReleaseVersionRsp_from_obj(obj)
    return setmetatable(obj, TGetReleaseVersionRsp)
end

function TGetReleaseVersionRsp.new(ActiveReleaseVersion, BackupReleaseVersion, AvailableReleaseVersion)
    return TGetReleaseVersionRsp_from_obj({
        ActiveReleaseVersion = ActiveReleaseVersion,
        BackupReleaseVersion = BackupReleaseVersion,
        AvailableReleaseVersion = AvailableReleaseVersion
    })
end
---@param obj ManagerVersion.GetReleaseVersionRsp
function TGetReleaseVersionRsp:init_from_obj(obj)
    self.ActiveReleaseVersion = obj.ActiveReleaseVersion
    self.BackupReleaseVersion = obj.BackupReleaseVersion
    self.AvailableReleaseVersion = obj.AvailableReleaseVersion
end

function TGetReleaseVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReleaseVersionRsp.group)
end

TGetReleaseVersionRsp.from_obj = TGetReleaseVersionRsp_from_obj

TGetReleaseVersionRsp.proto_property = {'ActiveReleaseVersion', 'BackupReleaseVersion', 'AvailableReleaseVersion'}

TGetReleaseVersionRsp.default = {'', '', ''}

TGetReleaseVersionRsp.struct = {
    {name = 'ActiveReleaseVersion', is_array = false, struct = nil},
    {name = 'BackupReleaseVersion', is_array = false, struct = nil},
    {name = 'AvailableReleaseVersion', is_array = false, struct = nil}
}

function TGetReleaseVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveReleaseVersion', self.ActiveReleaseVersion, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'BackupReleaseVersion', self.BackupReleaseVersion, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'AvailableReleaseVersion', self.AvailableReleaseVersion, 'string', false, errs,
        need_convert)

    TGetReleaseVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReleaseVersionRsp.proto_property, errs, need_convert)
    return self
end

function TGetReleaseVersionRsp:unpack(_)
    return self.ActiveReleaseVersion, self.BackupReleaseVersion, self.AvailableReleaseVersion
end

ManagerVersion.GetReleaseVersionRsp = TGetReleaseVersionRsp

---@class ManagerVersion.GetReleaseVersionReq
local TGetReleaseVersionReq = {}
TGetReleaseVersionReq.__index = TGetReleaseVersionReq
TGetReleaseVersionReq.group = {}

local function TGetReleaseVersionReq_from_obj(obj)
    return setmetatable(obj, TGetReleaseVersionReq)
end

function TGetReleaseVersionReq.new()
    return TGetReleaseVersionReq_from_obj({})
end
---@param obj ManagerVersion.GetReleaseVersionReq
function TGetReleaseVersionReq:init_from_obj(obj)

end

function TGetReleaseVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReleaseVersionReq.group)
end

TGetReleaseVersionReq.from_obj = TGetReleaseVersionReq_from_obj

TGetReleaseVersionReq.proto_property = {}

TGetReleaseVersionReq.default = {}

TGetReleaseVersionReq.struct = {}

function TGetReleaseVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetReleaseVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReleaseVersionReq.proto_property, errs, need_convert)
    return self
end

function TGetReleaseVersionReq:unpack(_)
end

ManagerVersion.GetReleaseVersionReq = TGetReleaseVersionReq

ManagerVersion.interface = mdb.register_interface('bmc.kepler.UpdateService.ManagerVersion', {
    PlatformMajorVersion = {'s', {}, true, nil, false},
    MajorVersion = {'s', {}, true, nil, false},
    MinorVersion = {'s', {}, true, nil, false},
    Version = {'s', {}, true, nil, false}
}, {GetReleaseVersion = {'a{ss}', 'sss', TGetReleaseVersionReq, TGetReleaseVersionRsp}}, {})

return ManagerVersion
