--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'manufacture.ipmi.ipmi_message'

local CT = enums.ChannelType

local ManufactureIpmiCmds = {}

ManufactureIpmiCmds.GetTestItemCount = {
    name = 'GetTestItemCount',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[40]=],
    decode = [=[<<0x40:1/unit:8, Type:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Count:1/unit:8>>]=],
    req = msg.GetTestItemCountReq,
    rsp = msg.GetTestItemCountRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.GetTestItemInfo = {
    name = 'GetTestItemInfo',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[41]=],
    decode = [=[<<0x41:1/unit:8, ReadOffset:1/unit:8, ReadLength:1]=] ..
        [=[/unit:8, Type:1/unit:8, Command:1/unit:8, Tail/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, EndOfList:1/unit:8, Tai]=] .. [=[l/string>>]=],
    req = msg.GetTestItemInfoReq,
    rsp = msg.GetTestItemInfoRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.StartDftTest = {
    name = 'StartDftTest',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[42]=],
    decode = [=[<<0x42:1/unit:8, ReadOffset:1/unit:8, ReadLength:1]=] ..
        [=[/unit:8, Type:1/unit:8, Command:1/unit:8, Index:1/]=] .. [=[unit:8, Tail/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, EndOfList:1/unit:8, Dis]=] .. [=[play/string>>]=],
    req = msg.StartDftTestReq,
    rsp = msg.StartDftTestRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.GetDftResult = {
    name = 'GetDftResult',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[43]=],
    decode = [=[<<0x43:1/unit:8, ReadOffset:1/unit:8, ReadLength:1]=] ..
        [=[/unit:8, Type:1/unit:8, Command:1/unit:8, Tail/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, EndOfList:1/unit:8, Dis]=] .. [=[play/string>>]=],
    req = msg.GetDftResultReq,
    rsp = msg.GetDftResultRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.GetProcessTime = {
    name = 'GetProcessTime',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[50]=],
    decode = [=[<<0x50:1/unit:8, Type:1/unit:8, Tail/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Time:2/unit:8>>]=],
    req = msg.GetProcessTimeReq,
    rsp = msg.GetProcessTimeRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.SetChipInfo = {
    name = 'SetChipInfo',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[52]=],
    decode = [=[<<0x52:1/unit:8, ComponentType:1/unit:8, Component]=] ..
        [=[Slot:1/unit:8, ChipType:1/unit:8, LinkFlag:1/unit:]=] ..
        [=[8, Offset:2/unit:8, Length:1/unit:8, Data:1/unit:8]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetChipInfoReq,
    rsp = msg.SetChipInfoRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.GetChipInfo = {
    name = 'GetChipInfo',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[53]=],
    decode = [=[<<0x53:1/unit:8, ComponentType:1/unit:8, Component]=] ..
        [=[Slot:1/unit:8, ChipType:1/unit:8, Offset:2/unit:8,]=] .. [=[ Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, EndOfList:1/unit:8, Dat]=] .. [=[a/string>>]=],
    req = msg.GetChipInfoReq,
    rsp = msg.GetChipInfoRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.SetTestCount = {
    name = 'SetTestCount',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[31]=],
    decode = [=[<<0x31:1/unit:8, FruId:1/unit:8, Tail/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetTestCountReq,
    rsp = msg.SetTestCountRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.GetTestCount = {
    name = 'GetTestCount',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[32]=],
    decode = [=[<<0x32:1/unit:8, FruId:1/unit:8, TestType:1/unit:8]=] .. [=[>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Count:1/unit:8>>]=],
    req = msg.GetTestCountReq,
    rsp = msg.GetTestCountRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.ClearCmos = {
    name = 'ClearCmos',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,08,11]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x08:1/unit:8, 0x11:1/un]=] .. [=[it:8, Action:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Status:1/unit:8>>]=],
    req = msg.ClearCmosReq,
    rsp = msg.ClearCmosRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.GetTestType = {
    name = 'GetTestType',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[39]=],
    decode = [=[<<0x39:1/unit:8, FRUDeviceID:1/unit:8, TestType:1/]=] .. [=[unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Open:1/unit:8, TestType]=] .. [=[:1/unit:8>>]=],
    req = msg.GetTestTypeReq,
    rsp = msg.GetTestTypeRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.SetTestType = {
    name = 'SetTestType',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[38]=],
    decode = [=[<<0x38:1/unit:8, FRUDeviceID:1/unit:8, TestType:1/]=] .. [=[unit:8, Open:1/unit:8, Param:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetTestTypeReq,
    rsp = msg.SetTestTypeRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.ReadVersionData = {
    name = 'ReadVersionData',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[08]=],
    decode = [=[<<0x08:1/unit:8, FruId:1/unit:8, VerType:1/unit:8,]=] .. [=[ Offset:1/unit:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, EndOfList:1/unit:8, Dat]=] .. [=[a/string>>]=],
    req = msg.ReadVersionDataReq,
    rsp = msg.ReadVersionDataRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.ImportImageToGpu = {
    name = 'ImportImageToGpu',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[72]=],
    decode = [=[<<0x72:1/unit:8, Length:2/unit:8, Width:2/unit:8, ]=] .. [=[Bpp:1/unit:8, Path/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.ImportImageToGpuReq,
    rsp = msg.ImportImageToGpuRsp,
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.SetDdrTestConfiguration = {
    name = 'SetDdrTestConfiguration',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,78]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x78:1/unit:8, Length:1/]=] .. [=[unit:8, Tail/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Result:1/unit:8>>]=],
    req = msg.SetDdrTestConfigurationReq,
    rsp = msg.SetDdrTestConfigurationRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

ManufactureIpmiCmds.GetDdrTestResult = {
    name = 'GetDdrTestResult',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.DiagnoseMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,79]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x79:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Length:1/unit:8, Result:4/unit:8>>]=],
    req = msg.GetDdrTestResultReq,
    rsp = msg.GetDdrTestResultRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

return ManufactureIpmiCmds
