-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDftCfgMgmt = {}

---@class MDftCfgMgmt.DftPackageFilename
---@field DftPackageFilename string
local TDftPackageFilename = {}
TDftPackageFilename.__index = TDftPackageFilename
TDftPackageFilename.group = {}

local function TDftPackageFilename_from_obj(obj)
    return setmetatable(obj, TDftPackageFilename)
end

function TDftPackageFilename.new(DftPackageFilename)
    return TDftPackageFilename_from_obj({DftPackageFilename = DftPackageFilename or [=[]=]})
end
---@param obj MDftCfgMgmt.DftPackageFilename
function TDftPackageFilename:init_from_obj(obj)
    self.DftPackageFilename = obj.DftPackageFilename or [=[]=]
end

function TDftPackageFilename:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDftPackageFilename.group)
end

TDftPackageFilename.from_obj = TDftPackageFilename_from_obj

TDftPackageFilename.proto_property = {'DftPackageFilename'}

TDftPackageFilename.default = {''}

TDftPackageFilename.struct = {{name = 'DftPackageFilename', is_array = false, struct = nil}}

function TDftPackageFilename:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DftPackageFilename', self.DftPackageFilename, 'string', false, errs, need_convert)

    TDftPackageFilename:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDftPackageFilename.proto_property, errs, need_convert)
    return self
end

function TDftPackageFilename:unpack(_)
    return self.DftPackageFilename
end

MDftCfgMgmt.DftPackageFilename = TDftPackageFilename

return MDftCfgMgmt
