-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDeviceChip = {}

---@class MDeviceChip.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj MDeviceChip.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

MDeviceChip.Slot = TSlot

---@class MDeviceChip.DeviceType
---@field DeviceType integer
local TDeviceType = {}
TDeviceType.__index = TDeviceType
TDeviceType.group = {}

local function TDeviceType_from_obj(obj)
    return setmetatable(obj, TDeviceType)
end

function TDeviceType.new(DeviceType)
    return TDeviceType_from_obj({DeviceType = DeviceType})
end
---@param obj MDeviceChip.DeviceType
function TDeviceType:init_from_obj(obj)
    self.DeviceType = obj.DeviceType
end

function TDeviceType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceType.group)
end

TDeviceType.from_obj = TDeviceType_from_obj

TDeviceType.proto_property = {'DeviceType'}

TDeviceType.default = {0}

TDeviceType.struct = {{name = 'DeviceType', is_array = false, struct = nil}}

function TDeviceType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)

    TDeviceType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceType.proto_property, errs, need_convert)
    return self
end

function TDeviceType:unpack(_)
    return self.DeviceType
end

MDeviceChip.DeviceType = TDeviceType

---@class MDeviceChip.Chip
---@field Chip integer
local TChip = {}
TChip.__index = TChip
TChip.group = {}

local function TChip_from_obj(obj)
    return setmetatable(obj, TChip)
end

function TChip.new(Chip)
    return TChip_from_obj({Chip = Chip})
end
---@param obj MDeviceChip.Chip
function TChip:init_from_obj(obj)
    self.Chip = obj.Chip
end

function TChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChip.group)
end

TChip.from_obj = TChip_from_obj

TChip.proto_property = {'Chip'}

TChip.default = {0}

TChip.struct = {{name = 'Chip', is_array = false, struct = nil}}

function TChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Chip', self.Chip, 'uint8', false, errs, need_convert)

    TChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChip.proto_property, errs, need_convert)
    return self
end

function TChip:unpack(_)
    return self.Chip
end

MDeviceChip.Chip = TChip

return MDeviceChip
