# 1.功能简介

dft装备测试项管理、路由分发



# 2.关键特性

1、dft装备测试项管理、路由分发
  **测试序列图**
  ![image-20240105161310414](http://image.huawei.com/tiny-lts/v1/images/72d46dc176f7caeea736424996f97f8a_1112x1021.png)

2、ipmi获取组件版本
  用于装备脚本获取板卡的各种版本信息，包括mcu版本、pcb版本、cpld版本、vrd版本、csr版本、bmc版本等，关键目录：
  ```text
├─lualib                                       
│  └─external_interface
│     └─ function_get_version.lua         # 用于从板卡对象、网卡对象、fru对象获取各种版本信息
└─ ipmi_cmd
    └─ read_version_data.lua         # ipmi接口的具体实现
```
  具体见对外接口

3、关键目录结构分析

```yaml
manufacture: 
	manufacture_manufacture_app.lua     # 装备包裁剪部分的组件入口
src:
	lualib: 
		device_chip:                    # vga接口的单独管理
		external_interface:             # 汇集其他组件信息提供统一获取接口
		ipmi_cmd:                       # ipmi命令的具体实现
		factory.lua                     # 全局对象句柄注册池
		manufacture.lua                 # 组件入口，包含ipmi注册、rpc注册、对象分发、组件初始化、组件关键线程
		manufacture_service.lua         # 完成装备路由表的建立和查询接口的封装
```





# 3.对外接口

### <1> 装备通用测试项ipmi

**测试示例**

| 测试类型 type | 测试类型                                                     |
| ------------- | ------------------------------------------------------------ |
| 1             | 直接自检，由APP提供检验结果                                  |
| 2             | 需要人工干预的前提条件，比如需要接环回头、需要设置屏幕等，由各APP提供测试结果 |
| 3             | 拷机测试项                                                   |
| 4             | 需要人工检查结果，比如LED灯需要人工查看是否正常，需要由装备人员确定检测结果 |
| 5             | 需要人工操作，如button 、LCD                                 |
| 6             | 需要与装备进行交互，需要装备侧软件比对数据来确定测试结果     |
| 255           | 无效的测试项，不进行注册                                     |

 

①查询测试项数目

命令模板：0x30 0x90 0x40 type —— type来自上表

![img](http://image.huawei.com/tiny-lts/v1/images/6fb4e0e193fef978daa052ee3fec614e_715x73.png@900-0-90-f.png) 

表示有 0x12 个自检项

②查询测试项的详细信息

查询方式为遍历查询 raw 0x30 0x90 0x41 0x00 0x20 type index

index 取自 0 - 0x12

查询结果举例：

![img](http://image.huawei.com/tiny-lts/v1/images/5687f2aef086ffc4d2e4cb67774f5d4f_824x107.png@900-0-90-f.png) 

举例说明某一次返回值的例子

解析方式为

第0个字节表示状态，通常成功，为00

第1个字节：是否打印完全标志位，00表示打印没有结束，80表示返回打印结束

第2个字节：dftid ，0b转为十六进制转换过来为11，表示对flash的测试

第3,4,5,6字节：slot 

第7字节：device_num

第8到后面的字节：测试项描述，可以使用ascll转换工具查看信息

![img](http://image.huawei.com/tiny-lts/v1/images/e9620f58fbe316b42ed110863686c1ac_1397x618.png@900-0-90-f.png) 

 

③启动测试

方式一：

raw 0x30 0x90 0x42 0x00 0x20 type 0x01 index

返回无报错即表明启动测试成功

方式二：

raw 0x30 0x90 0x42 0x00 0x20 type 0x01 dftid slot device_num

这条命令的输入来源是第二步获取到的。

举例启动 Flash的测试：

![img](http://image.huawei.com/tiny-lts/v1/images/4ee2bda15bf23fbb8ab190a8d985174b_871x90.png@900-0-90-f.png) 

80表示返回打印结束

 

其中存在特殊情况，一些测试项需要传入参数。传入参数时需要特殊情况

方式一：

raw 0x30 0x90 0x42 0x00 0x20 type 0xa1 index param（参数长度一般为1）

长度一般为1

 

方式二：

raw 0x30 0x90 0x42 0x00 0x20 type 0xe1 dftid slot device_num param（参数长度一般为1）

 ④查询测试项结果

方式一：

raw 0x30 0x90 0x43 0x00 0x20 type index

返回结果举例：

![img](http://image.huawei.com/tiny-lts/v1/images/0af23cdd809b4d6794cfa19905a57562_749x118.png@900-0-90-f.png) 

解析方式为

第1个字节：是否打印完全标志位，00表示打印没有结束，80表示返回打印结束

第2个字节：00表示自检结果成功，01表示失败,ff表示不涉及

第3个字节：dftid ，0b表示flash

第4,5,6,7字节：slot

第8字节：device_num

第9到后面的字节：测试项描述，可以使用ascll转换工具查看信息

 

方式二：

raw 0x30 0x90 0x43 0x00 0x20 type dftid slot device_num

 

![img](http://image.huawei.com/tiny-lts/v1/images/084adc78e44ccfa8378b79f524335c85_945x113.png@900-0-90-f.png) 

与方式一结果相同

⑤停止测试

方式一：

raw 0x30 0x90 0x42 0x00 0x20 type 0x00 index

返回无报错即表明启动测试成功

方式二：

raw 0x30 0x90 0x42 0x00 0x20 type 0x00 dftid slot device_num



### <2> 版本获取ipmi

  命令格式： 0x30  0x90 0x08  {fruid}  {type}  0x00  0xff

  返回值：80/00  版本字符串的每一位的Ascii码

  type取值范围：

| type                   | cmd  |
| ---------------------- | ---- |
| pcb version            | 0x00 |
| bmc main version       | 0x01 |
| cpld version           | 0x02 |
| sdr version            | 0x05 |
| bios version           | 0x06 |
| uboot version          | 0x08 |
| bmc backup version     | 0x0C |
| uboot backup version   | 0x10 |
| bmc available version  | 0x18 |
| sr version             | 0x19 |
| vrd version            | 0x1A |
| mcu version            | 0x1B |
| all version(fruid = 0) | 0xFF |



### <3> vga 前后使能命令ipmi

0x30 0x90 0x52 0x42 0x00 0x01 0x00 0x00 0x00 0x01 ${Swich_cmd}

Swich_cmd取值范围
2：装备前置VGA

3：装备后置VGA

0：正常默认模式

### <4>ipmi:设置上下电次数和ac

0x30 0x90 0x31 {type} {count}

type == 2 count == n 表示强制上下电n次

type == 3 表示ac



# 4.配置介绍

装备组件对测试项本身只提供路由转发功能，测试项由各个相关组件定义、配置以及实现功能调用

组件需要实现的接口：

![image-20240108194521392](http://image.huawei.com/tiny-lts/v1/images/f0b561085c2a2152fc9dba0014504569_607x227.png) 

该接口包含属性：

```
ItemName:   	        测试项名称

Type:              		测试项类型

Id:                 	测试项id

Slot:                	测试项所在槽位（分组）

DeviceNum:  		    设备数量

ProcessPeriod:	        测试时长

PrompteReady: 	        测试前提示

PrompteFinish:          测试完成提示

Param:                  测试参数

Status：                当前测试状态，取值"Complete","Testing","Unstart"
```

以及三个测试方法：

```
Start():                  启动测试

Stop():                   停止测试

GetResult():              获取测试结果。返回值：两个字符串。第一个字符串必须为枚举{"Succeed","Failed","Non"}中一个。第二个字符串为任意长提示字符
```



```
组件使用时通常做三件事：
1. 定义测试项名称，实现 bmc.kepler.Manufacture 接口，并定义测试需要使用到的私有属性
2. 实现测试方法注册，有如下规则：
	（1）Start/Stop 不需要返回值，通过维护Status状态来表示当前测试情况，启动测试时要将Status置为Testing或者Complete,结束测试时要置为Unstart
	（2）GetResult 有两个返回值，第一个为字符串，限制为这三个{"Succeed","Failed","Non"}，分别表示测试项成功、失败和不涉及结果查询。
				第二个字符串为测试描述，可以返回提示语表示当前测试项的状况。
	（3）Status和GetResult需要配合使用，GetResult只有在Status已经置为Complete时才可以被装备组件调用到。
3. 配置测试项CSR，除了Param属性外的所有属性通常都来自CSR
```

举例：某个组件需要测试adc电压值

测试项定义为： Dft3V3Vlot

除了实现 bmc.kepler.Manufacture 外，额外定义了私有属性，其csr配置如下：

```json
"Dft3V3Vlot_1": {
    "ItemName": "VCC 3.3V Test",
	"Type": 1,
	"Id": 20,
    "Slot": "${GroupId}",
    "DeviceNum": 2,
    "ProcessPeriod": 65535,
    "PrompteReady": "",
    "PrompteFinish": "",
    "VoltValue": "#/Accessor_Adc4STBVlot.Value",     #  关联到要测试的ADC寄存器
    "PowOnStandValue": 2700,                         #  上电时电压的基准值
    "PowOffStandValue": 0,                           #  下电时电压的基准值
    "HystValue": 108,                                #  电压浮动阈值，实际测量值在 基准值±浮动阈值
    "DevPowerStatus": "#/Accessor_PowerGd.Value"     #  当前上下电状态
}
```

需要实现rpc方法(伪代码)：

```lua
local result = "Non"
function Start(obj){
	obj.Status = "Testing"
    -- 电压值测试，假设测试结果为成功
    result = "Succeed"
    obj.Status = "Complete"
}
function Stop(obj){
	obj.Status = "Unstart"
}
function GetResult(obj){
	return result, "vlot test ok"
}

```















