# manifest

此代码仓为openUBMC产品集成配置仓。

## 开发环境创建

openUBMC目前仅支持在Ubuntu 24.04系统上进行代码开发。为方便开发者快速搭建环境，我们提供以下三种方式：

方法一：本地环境初始化脚本（适用于Ubuntu 24.04系统）

方法二：使用官方发布的Docker镜像创建Docker容器

方法三：从源码构建Docker容器（通过提供的Dockerfile源码文件创建开发环境）

以上三种方式均可配置完整的openUBMC开发环境。

- 如果您的系统已经是Ubuntu 24.04，可以直接运行本地脚本初始化环境。

- 如果希望使用容器化开发，可以选择方法二或方法三的Docker方式。方法二中的Docker环境是已经发布的稳定版本，仅包含openUBMC的开发环境；方法三中的Docker环境是在研的最新版本，包含openUBMC的开发环境，Qemu以及Studio的编译和运行的依赖等。

请根据实际需求选择适合的方案。

### 方法一：本地环境初始化

> [NOTE]
> 此方法仅支持在Ubuntu 24.04系统中使用！
> 环境初始化脚本优先使用本地环境配置的apt源，下载bingo工具。若本地环境未配置，则会自动配置openUBMC官方的apt源。

此代码仓根目录下的init.py脚本是openUBMC开发环境初始化的代码实现。开发者可将此代码仓拉取到本地，前往[openUBMC社区软件应用中心](https://www.openubmc.cn/marketplace)下载社区组件bmcsdk。并将下载的bmcsdk压缩包路径作为参数传入，执行此脚本进行开发环境初始化。

```
cd manifest
python3 init.py -path <bmc_sdk.zip文件路径> -user <openUBMC社区用户名> -psw <openUBMC社区用户密码>
```

> [NOTE]
> 未指定 `-psw` 和 `-user` 参数时需要用户通过交互式输入账号密码。 **推荐**

### 方法二：官方发布的Docker镜像创建openUBMC开发环境

此方式的实现请参考[官方文档-Docker开发环境搭建章节](https://www.openubmc.cn/docs/zh/development/quick_start/prepare_environment/docker_env.html)

### 方法三：dockerfile源码制作openUBMC开发环境

> [NOTE]
> dockerfile制作镜像过程中，默认配置openUBMC官方提供的apt源并完成bingo下载。如需使用您自己的apt源，可修改 init.py --> install_bingo()方法中的apt源配置。

在本仓中提供dockerfile文件，该文件包含了构建openUBMC环境镜像的所有指令。

1、开发者需前往[openUBMC社区软件应用中心](https://openubmc.cn/marketplace)下载社区组件bmcsdk，并将下载的bmcsdk文件存放在此代码仓目录下。然后，在manifest目录下，执行以下命令可构建一个名称为`openubmc/xx.yy`的镜像。需注意，`USER`和`PASSWORD`参数值为开发者自己的社区用户名和密码：

```
docker build -t openubmc/xx.yy . --build-arg BMC_SDK_PATH=./bmc_sdk.zip --build-arg USER=<openUBMC社区用户名> --build-arg PASSWORD=<openUBMC社区用户密码>
```

参数说明：

`-t` 定义镜像名称

2、构建成功后，可查看镜像是否加载成功：

```
docker images
```


3、创建上述生成的`openubmc/xx.yy`镜像的Container实例，并将Container实例命名为`openubmc`：
```
docker run -itd --mount type=bind,source=/root/workspace,target=/home/workspace --restart=always --name openubmc openubmc/xx.yy /bin/bash
```

参数说明：

`-itd` 以非交互方式启动容器。

`--mount` 将上述在宿主机创建的工作文件夹`/root/workspace`与Container中的`/home/workspace`链接作为同步文件夹。

`--restart=always` 系统重启时自动启动容器。

`--name` 定义容器的名称。

4、查看正在运行的容器：

```
docker ps
```

5、进入`openubmc`容器：

```
docker exec -it openubmc /bin/bash
```

执行成功，此时已进入`openubmc`容器。

## git仓库配置

上述步骤已经在环境中成功配置openUBMC开发所需要的工具和依赖。接下来开发者需在本地完成Git的全局配置，并将本地SSH公钥配置至gitcode仓库的ssh密钥中，即可开始代码开发、上库、和本地构建等工作。以下第二至第四步骤可参考[GitCode的SSH配置](https://docs.gitcode.com/v1-docs/docs/users/ssh-key/)。

1、首先开发者需要在本地完成Git的全局配置：

```
git config --global user.name <你的用户名>
git config --global user.email <你的邮箱>
```
2、在本地执行以下命令生成RSA密钥：
```
ssh-keygen -t rsa -b 2048 -C <你的邮箱>
```
3、查看 RSA 公钥：

```
cat ~/.ssh/id_rsa.pub
```
4、上述步骤会在本地的控制台中返回RSA密钥，开发者需要将此密钥添加到gitcode的SSH公钥中。

之后，开发者便可以在容器中克隆git仓库中的代码，并在容器中进行代码开发和构建。

# Qemu启动
openUBMC还提供了一套Qemu仿真环境，便于开发者验证openUBMC的制品包。开发者通过执行以下命令可以一键式启动Qemu仿真环境，在其中体验openUBMC。

```shell
python3 build/works/packet/qemu_shells/vemake_1711.py
```
当出现如下回显时，Qemu环境就正式启动了
```shell
Uncompressing... done, booting...
[    0.000000] Booting Linux on physical CPU 0x0000000000 [0x412fd050]
[    0.000000] Linux version 5.10.0 (oe-user@oe-host) (aarch64-euler-linux-gcc (BiSheng Embedded CPU 302.1.0.B016) 7.3.0, GNU ld (BiSheng Embedded CPU 302.1.0.B016) 2.41) #1 SMP PREEMPT Tue Nov 26 22:03:48 CST 2024
```

当然你也可以通过配置`build/works/packet/qemu_shells/config.json`文件来决定启动Qemu的方式,同时也可以参考`build/works/packet/qemu_shells/schema.json`来获取对应配置详情。