-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local log = require 'mc.logging'
local _, lsw_drv = pcall(require, 'lsw_drv')
local monitor = require 'domain.debug.monitor'
local defs = require 'domain.defs'
local vlan = class()

local mtr = monitor.get_instance()

function vlan:ctor(obj, parent)
    self.obj = obj
    self.parent = parent
end

function vlan:config()
    local res = lsw_drv.l_lsw_single_vlan_init(self.parent:get_type(), self.obj.Unit,
        self.obj.VlanId, self.obj.Member, self.obj.Untaged)
    mtr:update_state(defs.NetConfigIdx.SingleVlanInit, res)
    if not res then
        log:error('[lsw]single vlan(%d) init fail', self.obj.VlanId)
    else
        log:notice('[lsw]single vlan(%d) init success', self.obj.VlanId)
    end
end

function vlan:start_init()
    self:config()
end

function vlan:get_info()
    return string.format("[ ===VlanId(%s): Member(%s), Untaged(%s) ===] ",
        self.obj.VlanId, self.obj.Member, self.obj.Untaged)
end

return vlan
