-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local defs = require 'domain.defs'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local _, lsw_drv = pcall(require, 'lsw_drv')
local debug = class()

function debug:ctor()
    self.chipType = defs.LSW_TYPE.GE_SWITCHOEM_RTL8367
end

function debug:drv_register()
    self.drv_debug = {
        [defs.DEBUG_FUNC.CHIP_REG_READ] = lsw_drv.l_getAsicReg,
        [defs.DEBUG_FUNC.CHIP_REG_WRITE] = lsw_drv.l_setAsicReg,
        [defs.DEBUG_FUNC.PORT_REG_READ] = lsw_drv.l_port_phyReg_get,
        [defs.DEBUG_FUNC.PORT_REG_WRITE] = lsw_drv.l_port_phyReg_set,
        [defs.DEBUG_FUNC.GET_PORT_ENABLE] = lsw_drv.l_get_port_enable,
        [defs.DEBUG_FUNC.GET_PORT_STP_STATE] = lsw_drv.l_get_port_stp_state,
        [defs.DEBUG_FUNC.GET_PORT_MAC_INFO] = lsw_drv.l_get_port_mac_info,
        [defs.DEBUG_FUNC.GET_PORT_L2_ADDR] = lsw_drv.l_get_port_l2_addr,
        [defs.DEBUG_FUNC.SET_PORT_ENABLE] = lsw_drv.l_set_port_enable,
        [defs.DEBUG_FUNC.SET_PORT_STP_STATE] = lsw_drv.l_set_port_stp_state,
        [defs.DEBUG_FUNC.GET_SWITCH_ERROR_CODE] = lsw_drv.l_get_switch_error_code,
        [defs.DEBUG_FUNC.SET_PORT_MAC_ADDR] = lsw_drv.l_set_port_mac_addr,
        [defs.DEBUG_FUNC.FLUSH_PORT_ADDR] = lsw_drv.l_flush_port_l2_addr
    }
end

function debug:init()
    self:drv_register()
end

function debug:op_reg(type, ...)
    return self:func_call(type, ...)
end

function debug:update_lsw_type(type)
    log:notice("[lsw] debug update chip type: %s", type)
    self.chipType = type
end

function debug:get_lsw_type()
    return self.chipType
end

function debug:func_call(func_type, ...)
    return self.drv_debug[func_type](self:get_lsw_type(), ...)
end

return singleton(debug)
