-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NetConfig = {}

---@class NetConfig.MasterSmmLinkNetId
---@field MasterSmmLinkNetId integer
local TMasterSmmLinkNetId = {}
TMasterSmmLinkNetId.__index = TMasterSmmLinkNetId
TMasterSmmLinkNetId.group = {}

local function TMasterSmmLinkNetId_from_obj(obj)
    return setmetatable(obj, TMasterSmmLinkNetId)
end

function TMasterSmmLinkNetId.new(MasterSmmLinkNetId)
    return TMasterSmmLinkNetId_from_obj({MasterSmmLinkNetId = MasterSmmLinkNetId})
end
---@param obj NetConfig.MasterSmmLinkNetId
function TMasterSmmLinkNetId:init_from_obj(obj)
    self.MasterSmmLinkNetId = obj.MasterSmmLinkNetId
end

function TMasterSmmLinkNetId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMasterSmmLinkNetId.group)
end

TMasterSmmLinkNetId.from_obj = TMasterSmmLinkNetId_from_obj

TMasterSmmLinkNetId.proto_property = {'MasterSmmLinkNetId'}

TMasterSmmLinkNetId.default = {0}

TMasterSmmLinkNetId.struct = {{name = 'MasterSmmLinkNetId', is_array = false, struct = nil}}

function TMasterSmmLinkNetId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MasterSmmLinkNetId', self.MasterSmmLinkNetId, 'uint8', true, errs, need_convert)

    TMasterSmmLinkNetId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMasterSmmLinkNetId.proto_property, errs, need_convert)
    return self
end

function TMasterSmmLinkNetId:unpack(_)
    return self.MasterSmmLinkNetId
end

NetConfig.MasterSmmLinkNetId = TMasterSmmLinkNetId

NetConfig.interface = mdb.register_interface('bmc.kepler.Managers.Chassis.NetConfig',
    {MasterSmmLinkNetId = {'y', nil, true, nil, false}}, {}, {})

return NetConfig
