-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local MgmtPort = {}

---@class MgmtPort.VLANId
---@field VLANId integer
local TVLANId = {}
TVLANId.__index = TVLANId
TVLANId.group = {}

local function TVLANId_from_obj(obj)
    return setmetatable(obj, TVLANId)
end

function TVLANId.new(VLANId)
    return TVLANId_from_obj({VLANId = VLANId or 0})
end
---@param obj MgmtPort.VLANId
function TVLANId:init_from_obj(obj)
    self.VLANId = obj.VLANId or 0
end

function TVLANId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANId.group)
end

TVLANId.from_obj = TVLANId_from_obj

TVLANId.proto_property = {'VLANId'}

TVLANId.default = {0}

TVLANId.struct = {{name = 'VLANId', is_array = false, struct = nil}}

function TVLANId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VLANId', self.VLANId, 'uint16', true, errs, need_convert)

    TVLANId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANId.proto_property, errs, need_convert)
    return self
end

function TVLANId:unpack(_)
    return self.VLANId
end

MgmtPort.VLANId = TVLANId

---@class MgmtPort.VLANEnabled
---@field VLANEnabled boolean
local TVLANEnabled = {}
TVLANEnabled.__index = TVLANEnabled
TVLANEnabled.group = {}

local function TVLANEnabled_from_obj(obj)
    return setmetatable(obj, TVLANEnabled)
end

function TVLANEnabled.new(VLANEnabled)
    return TVLANEnabled_from_obj({VLANEnabled = VLANEnabled or false})
end
---@param obj MgmtPort.VLANEnabled
function TVLANEnabled:init_from_obj(obj)
    self.VLANEnabled = obj.VLANEnabled or false
end

function TVLANEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANEnabled.group)
end

TVLANEnabled.from_obj = TVLANEnabled_from_obj

TVLANEnabled.proto_property = {'VLANEnabled'}

TVLANEnabled.default = {false}

TVLANEnabled.struct = {{name = 'VLANEnabled', is_array = false, struct = nil}}

function TVLANEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VLANEnabled', self.VLANEnabled, 'bool', true, errs, need_convert)

    TVLANEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANEnabled.proto_property, errs, need_convert)
    return self
end

function TVLANEnabled:unpack(_)
    return self.VLANEnabled
end

MgmtPort.VLANEnabled = TVLANEnabled

---@class MgmtPort.Mac
---@field Mac string
local TMac = {}
TMac.__index = TMac
TMac.group = {}

local function TMac_from_obj(obj)
    return setmetatable(obj, TMac)
end

function TMac.new(Mac)
    return TMac_from_obj({Mac = Mac})
end
---@param obj MgmtPort.Mac
function TMac:init_from_obj(obj)
    self.Mac = obj.Mac
end

function TMac:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMac.group)
end

TMac.from_obj = TMac_from_obj

TMac.proto_property = {'Mac'}

TMac.default = {''}

TMac.struct = {{name = 'Mac', is_array = false, struct = nil}}

function TMac:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mac', self.Mac, 'string', true, errs, need_convert)

    TMac:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMac.proto_property, errs, need_convert)
    return self
end

function TMac:unpack(_)
    return self.Mac
end

MgmtPort.Mac = TMac

---@class MgmtPort.LinkStatus
---@field LinkStatus string
local TLinkStatus = {}
TLinkStatus.__index = TLinkStatus
TLinkStatus.group = {}

local function TLinkStatus_from_obj(obj)
    return setmetatable(obj, TLinkStatus)
end

function TLinkStatus.new(LinkStatus)
    return TLinkStatus_from_obj({LinkStatus = LinkStatus})
end
---@param obj MgmtPort.LinkStatus
function TLinkStatus:init_from_obj(obj)
    self.LinkStatus = obj.LinkStatus
end

function TLinkStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkStatus.group)
end

TLinkStatus.from_obj = TLinkStatus_from_obj

TLinkStatus.proto_property = {'LinkStatus'}

TLinkStatus.default = {''}

TLinkStatus.struct = {{name = 'LinkStatus', is_array = false, struct = nil}}

function TLinkStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkStatus', self.LinkStatus, 'string', false, errs, need_convert)

    TLinkStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkStatus.proto_property, errs, need_convert)
    return self
end

function TLinkStatus:unpack(_)
    return self.LinkStatus
end

MgmtPort.LinkStatus = TLinkStatus

---@class MgmtPort.AdaptiveFlag
---@field AdaptiveFlag boolean
local TAdaptiveFlag = {}
TAdaptiveFlag.__index = TAdaptiveFlag
TAdaptiveFlag.group = {}

local function TAdaptiveFlag_from_obj(obj)
    return setmetatable(obj, TAdaptiveFlag)
end

function TAdaptiveFlag.new(AdaptiveFlag)
    return TAdaptiveFlag_from_obj({AdaptiveFlag = AdaptiveFlag})
end
---@param obj MgmtPort.AdaptiveFlag
function TAdaptiveFlag:init_from_obj(obj)
    self.AdaptiveFlag = obj.AdaptiveFlag
end

function TAdaptiveFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAdaptiveFlag.group)
end

TAdaptiveFlag.from_obj = TAdaptiveFlag_from_obj

TAdaptiveFlag.proto_property = {'AdaptiveFlag'}

TAdaptiveFlag.default = {false}

TAdaptiveFlag.struct = {{name = 'AdaptiveFlag', is_array = false, struct = nil}}

function TAdaptiveFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AdaptiveFlag', self.AdaptiveFlag, 'bool', false, errs, need_convert)

    TAdaptiveFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAdaptiveFlag.proto_property, errs, need_convert)
    return self
end

function TAdaptiveFlag:unpack(_)
    return self.AdaptiveFlag
end

MgmtPort.AdaptiveFlag = TAdaptiveFlag

---@class MgmtPort.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj MgmtPort.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MgmtPort.Type = TType

---@class MgmtPort.Silkscreen
---@field Silkscreen string
local TSilkscreen = {}
TSilkscreen.__index = TSilkscreen
TSilkscreen.group = {}

local function TSilkscreen_from_obj(obj)
    return setmetatable(obj, TSilkscreen)
end

function TSilkscreen.new(Silkscreen)
    return TSilkscreen_from_obj({Silkscreen = Silkscreen})
end
---@param obj MgmtPort.Silkscreen
function TSilkscreen:init_from_obj(obj)
    self.Silkscreen = obj.Silkscreen
end

function TSilkscreen:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSilkscreen.group)
end

TSilkscreen.from_obj = TSilkscreen_from_obj

TSilkscreen.proto_property = {'Silkscreen'}

TSilkscreen.default = {''}

TSilkscreen.struct = {{name = 'Silkscreen', is_array = false, struct = nil}}

function TSilkscreen:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Silkscreen', self.Silkscreen, 'string', true, errs, need_convert)

    TSilkscreen:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSilkscreen.proto_property, errs, need_convert)
    return self
end

function TSilkscreen:unpack(_)
    return self.Silkscreen
end

MgmtPort.Silkscreen = TSilkscreen

---@class MgmtPort.DevicePortId
---@field DevicePortId integer
local TDevicePortId = {}
TDevicePortId.__index = TDevicePortId
TDevicePortId.group = {}

local function TDevicePortId_from_obj(obj)
    return setmetatable(obj, TDevicePortId)
end

function TDevicePortId.new(DevicePortId)
    return TDevicePortId_from_obj({DevicePortId = DevicePortId})
end
---@param obj MgmtPort.DevicePortId
function TDevicePortId:init_from_obj(obj)
    self.DevicePortId = obj.DevicePortId
end

function TDevicePortId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevicePortId.group)
end

TDevicePortId.from_obj = TDevicePortId_from_obj

TDevicePortId.proto_property = {'DevicePortId'}

TDevicePortId.default = {0}

TDevicePortId.struct = {{name = 'DevicePortId', is_array = false, struct = nil}}

function TDevicePortId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevicePortId', self.DevicePortId, 'uint8', true, errs, need_convert)

    TDevicePortId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevicePortId.proto_property, errs, need_convert)
    return self
end

function TDevicePortId:unpack(_)
    return self.DevicePortId
end

MgmtPort.DevicePortId = TDevicePortId

---@class MgmtPort.DeviceId
---@field DeviceId integer
local TDeviceId = {}
TDeviceId.__index = TDeviceId
TDeviceId.group = {}

local function TDeviceId_from_obj(obj)
    return setmetatable(obj, TDeviceId)
end

function TDeviceId.new(DeviceId)
    return TDeviceId_from_obj({DeviceId = DeviceId})
end
---@param obj MgmtPort.DeviceId
function TDeviceId:init_from_obj(obj)
    self.DeviceId = obj.DeviceId
end

function TDeviceId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceId.group)
end

TDeviceId.from_obj = TDeviceId_from_obj

TDeviceId.proto_property = {'DeviceId'}

TDeviceId.default = {0}

TDeviceId.struct = {{name = 'DeviceId', is_array = false, struct = nil}}

function TDeviceId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint8', true, errs, need_convert)

    TDeviceId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceId.proto_property, errs, need_convert)
    return self
end

function TDeviceId:unpack(_)
    return self.DeviceId
end

MgmtPort.DeviceId = TDeviceId

---@class MgmtPort.EthId
---@field EthId integer
local TEthId = {}
TEthId.__index = TEthId
TEthId.group = {}

local function TEthId_from_obj(obj)
    return setmetatable(obj, TEthId)
end

function TEthId.new(EthId)
    return TEthId_from_obj({EthId = EthId})
end
---@param obj MgmtPort.EthId
function TEthId:init_from_obj(obj)
    self.EthId = obj.EthId
end

function TEthId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEthId.group)
end

TEthId.from_obj = TEthId_from_obj

TEthId.proto_property = {'EthId'}

TEthId.default = {0}

TEthId.struct = {{name = 'EthId', is_array = false, struct = nil}}

function TEthId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EthId', self.EthId, 'uint8', true, errs, need_convert)

    TEthId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEthId.proto_property, errs, need_convert)
    return self
end

function TEthId:unpack(_)
    return self.EthId
end

MgmtPort.EthId = TEthId

---@class MgmtPort.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MgmtPort.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MgmtPort.Id = TId

MgmtPort.interface = mdb.register_interface('bmc.kepler.Managers.EthernetInterfaces.MgmtPort', {
    Id = {'y', nil, true, nil, false},
    EthId = {'y', {}, true, nil, false},
    DeviceId = {'y', {}, true, nil, false},
    DevicePortId = {'y', nil, true, nil, false},
    Silkscreen = {'s', {}, true, nil, false},
    Type = {'s', nil, true, nil, false},
    AdaptiveFlag = {'b', nil, false, nil, false},
    LinkStatus = {'s', nil, false, nil, false},
    Mac = {'s', {}, true, nil, false},
    VLANEnabled = {'b', nil, true, false, false},
    VLANId = {'q', nil, true, 0, false}
}, {}, {})

return MgmtPort
