-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local vrd_mgmt_object = require 'vrd.vrd_mgmt_obj'
local client = require 'general_hardware.client'
local vrd_obj = require 'vrd.vrd_object'
local ipmi = require 'ipmi'
local lu = require 'luaunit'

TestVrdMgmtObj = {}


function TestVrdMgmtObj:test_get_vrd_info_failed()
    local obj = {
        SystemId = 1,
        CpuId = 0
    }
    local vrd_mgmt_obj = vrd_mgmt_object.new(obj, 1)
    local cc, _ = vrd_mgmt_obj.get_vrd_info_from_imu({}, 1, 0)
    lu.assertEquals(cc, nil)

    cc, _ = vrd_mgmt_obj.get_vrd_info_from_single_host_imu({}, 1, 0)
    lu.assertEquals(cc, nil)
end

local client_mock = client

local function GetCPUObjects()
    return {{PhysicalId = 0, LogicalId = 0}}
end

function TestVrdMgmtObj:test_get_vrd_info_success()
    local obj = {
        SystemId = 1,
        CpuId = 0
    }
    client.GetCPUObjects = GetCPUObjects

    local vrd_mgmt_obj = vrd_mgmt_object.new(obj, 1)
    local cc, _ = vrd_mgmt_obj.get_vrd_info_from_imu({}, 1, 0)
    lu.assertEquals(cc, nil)
    cc, _ = vrd_mgmt_obj.get_vrd_info_from_single_host_imu({}, 1, 0)
    lu.assertEquals(cc, nil)
    client.GetCPUObjects = client_mock.GetCPUObjects
end

function TestVrdMgmtObj:test_get_vrd_obj_failed()
    local cc = vrd_obj:get_vrd_info_from_imu({}, 0)
    lu.assertEquals(cc, nil)
end