-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local m2 = require 'unit_manager.class.unit.seu.m2_transform_card'

TestM2Transform = {}

function TestM2Transform:setUp()
    local tab = {}
    m2.mcu_obj = {
        interface = {
            query_upgrade_status = function() end
        }
    }
    m2.set_prop = function(_, k, v)
        tab[k] = v
    end
    m2.get_prop = function(_, k)
        return tab[k]
    end
end

-- 测试获取mcu状态失败
function TestM2Transform:test_update_mcu_status_fail()
    m2:set_prop('Count', 0)
    m2:set_prop('CpldStatus', 0)
    m2:update_mcu_status()
    m2:update_mcu_status()
    m2:update_mcu_status()
    m2:update_mcu_status()
    lu.assertEquals(m2:get_prop('Count'), 4)
    lu.assertEquals(m2:get_prop('CpldStatus'), 1)
end

-- 测试获取mcu状态成功
function TestM2Transform:test_update_mcu_status_succ()
    m2.mcu_obj = {
        interface = {
            query_upgrade_status = function()
                return 1
            end
        }
    }
    m2:set_prop('Count', 0)
    m2:set_prop('CpldStatus', 0)
    m2:update_mcu_status()
    m2:update_mcu_status()
    m2:update_mcu_status()
    m2:update_mcu_status()
    lu.assertEquals(m2:get_prop('Count'), 0)
    lu.assertEquals(m2:get_prop('CpldStatus'), 0)
end
