-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local security_object = require 'security_module.security_object'

TestSecurityObject = {}

local src_table = {
    Health = 1,
    Protocol = "TPM",
    Manufacturer = "HW",
    ProtocolVersion = "1.0",
    FirmwareVersion = "2.0"
}

function TestSecurityObject:test_update_properties()
    local s = security_object.new({}, "")
    s:update_properties(src_table)
    lu.assertEquals(s.obj.Health, src_table.Health)
end
