-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local retimer = require 'retimer.retimer_M88RT51632'

TestRetimer = {}

local retimer_mdb = {
    name = "retimer",
    FirmwareVersion = "",
    HealthStatus = 0,
    ChipName = "ExpBoard1 Retimer1"
}

function TestRetimer:test_update_firmware_version()
    local obj = retimer.new(retimer_mdb, "bus_id", "0101")
    obj:update_firmware_version()
    lu.assertEquals(obj.retimer_obj.FirmwareVersion, '')
end

function TestRetimer:test_update_firmware_severity()
    local obj = retimer.new(retimer_mdb, "bus_id", "0101")
    obj:update_firmware_severity()
    lu.assertEquals(obj.retimer_obj.HealthStatus, 0)
end

function TestRetimer:test_get_fw_id()
    local obj = retimer.new(retimer_mdb, "bus_id", "0101")
    local name = "ExpBoard6 Retimer1"
    local ret = obj:get_fw_id(name)
    lu.assertEquals(ret, "EXU_Retimer1_0101")

    local name = "CPUBoard6 Retimer1"
    local ret = obj:get_fw_id(name)
    lu.assertEquals(ret, "CPUBoard6Retimer1_0101")
end

function TestRetimer:test_get_software_id()
    local obj = retimer.new(retimer_mdb, "bus_id", "0101")
    local ret = obj:get_software_id("N/A")
    lu.assertEquals(ret, '')

    obj.get_board_prop = function(...)
        return "IT22MEBC"
    end
    local ret = obj:get_software_id("ExpBoard6 Retimer1")
    lu.assertEquals(ret, 'Retimer-IT22MEBC')
    obj.get_board_prop = function(...)
        return ""
    end
    local ret = obj:get_software_id("ExpBoard6 Retimer1")
    lu.assertEquals(ret, '')
end

function TestRetimer:test_get_board_prop()
    local obj = retimer.new(retimer_mdb, "bus_id", "0101")
    obj.get_parent_board_path = function(...)
        return nil
    end
    local ret = obj:get_board_prop("", "Name", "ExpBoard")
    lu.assertEquals(ret, "")
end

function TestRetimer:test_get_parent_board_path()
    local obj = retimer.new(retimer_mdb, "bus_id", "0101")
    local ret = obj:get_parent_board_path("010108", "ExpBoard")
    lu.assertEquals(ret, nil)
end