local lu = require 'luaunit'
local service = require 'retimer.upgrade.retimer_upg_service'

TestUpgServiceTest = {}

function TestUpgServiceTest:test_start()
    service.cfgs={['Firm1'] = {['component_id_ex'] = 0X13000007}}
    local res = service:upgrade_task(1,7,"/dev/shm/upgrade","false")
    lu.assertEquals(res, nil)
    
    service.retimer_collection={}
    local retimer_obj = {}
    retimer_obj.get_chip_type = function(self)
        return 7
    end
    table.insert(service.retimer_collection, retimer_obj)
    local res = service:upgrade_task(1,7,"/dev/shm/upgrade/Firmware1","false")
    lu.assertEquals(res, nil)

    retimer_obj.get_chip_type = function(self)
        return 0X13000007
    end
    service.register_chips_callback={}
    local res = service:upgrade_task(1,7,"/dev/shm/upgrade/Firmware1","false")
    lu.assertEquals(res, nil)

    service.register_chips_callback[0X13000007] = {}
    service.register_chips_callback[7] = {}
    service.register_chips_callback[0X13000007].upgrade_prepare_func = function(...)
        return false
    end
    local res = service:upgrade_task(1,7,"/dev/shm/upgrade/Firmware1","false")
    lu.assertEquals(res, nil)
end