local lu = require 'luaunit'
local base = require 'retimer.upgrade.retimer_upg_base'

TestUpgBaseTest = {}

function TestUpgBaseTest:test_start()
    local service = {retimer_upgrade_list = {}}
    service.retimer_upgrade_list = { [1] = {}}
    service.retimer_upgrade_list[1].agent = {get_power_status = function(...)
        return "ON"
    end}
    local res = base.upgrade_prepare_func(service, "/dev/shm/upgrade/Firmware1", 0X13000007)
    lu.assertEquals(res, false)
    
    service.retimer_upgrade_list[1].agent = {get_power_status = function(...)
        return "OFF"
    end}
    local res = base.upgrade_prepare_func(service, "/dev/shm/upgrade/Firmware1", 0X13000007)
    lu.assertEquals(res, true)
end

function TestUpgBaseTest:test_upgrade_single_retimer_finish_func()
    local retimer = {name = "Retimer1",retimer_obj = {Switch = 1}}
    local res = base.upgrade_single_retimer_finish_func({}, retimer)
    lu.assertEquals(res, true)
end

function TestUpgBaseTest:test_upgrade_finish_func()
    local service = {}
    service.retimer_upgrade_list={}
    service.retimer_upgrade_list[1]={bus = {}}
    local res = base.upgrade_finish_func(service)
    lu.assertEquals(res, true)
end

function TestUpgBaseTest:test_upgrade_single_retimer_func()
    local retimer = {name = "Retimer1",retimer_obj = {Switch = 1}}
    local res = base.upgrade_single_retimer_func(retimer,"/dev/shm/upgrade/Firmware1", 0X13000007)
    lu.assertEquals(res, false)
end