local lu = require 'luaunit'
local base = require 'retimer.retimer_base'

TestBaseTest = {}

function TestBaseTest:test_start()
    base.agent = {
        start = function()
            return true
        end,
        stop = function()
            return true
        end}
    base.upgrade_status = 1
    base.component_idex = 7
    base.retimer_obj = {TemperatureCelsius = 22, ChipName = "ExpBoard6 Retimer1", ChipType = 7
        ,FirmwareStorageChip = {
            Write = function() 
                return true
            end
        }
    }
    base.pos = "0202"
    base:init()
    base:cleanup()
    base:register_firmware_info()
    local res = base:get_upgrade_status()
    lu.assertEquals(res, 1)
    res = base:get_chip_type()
    lu.assertEquals(res, 7)
    res = base:get_chip_temp()
    lu.assertEquals(res, 22)
end

function TestBaseTest:test_trans_fw_to_ref_eeprom()
    local res = base:trans_fw_to_ref_eeprom("12345678")
    lu.assertEquals(res, true)
end
