local utils = require 'retimer.agent.retimer_agent_CS81532_utils'
local constants = require 'retimer.retimer_constants'
local lu = require 'luaunit'

TestRetimerAgentCS81532Utils = {}

function TestRetimerAgentCS81532Utils:test_temperature()
    local test = utils.PARAMETERS_DYNAMIC['TemperatureCelsius']
    local reg = {
        ['0'] = {change_mode = 0x00000f00,get_temp = 444},
        ['1'] = {change_mode = 0x00000f00,get_temp = 555},
        ena_reg = 1,
        use_pec = false
    }
    local protocol = {}
    protocol.retimer_write = function()
        return true, true
    end
    protocol.retimer_loop_read = function()
        return true, true
    end

    -- 负温
    protocol.retimer_read = function()
        return true, 0x3e
    end
    local _, res2 = test.fun(protocol, reg)
    lu.assertEquals(res2.temp_0, -31)
    res2 = test.callback(res2)
    lu.assertEquals(res2, -31)

    -- 正温
    protocol.retimer_read = function()
        return true, 0x2b5
    end
    _, res2 = test.fun(protocol, reg)
    lu.assertEquals(res2.temp_0, 114)

    -- 异常分支1
    protocol.retimer_write = function(obj)
        if not obj.data then
            return false, false
        end
        return true, true
    end
    local res3, _ = test.fun(protocol, reg)
    lu.assertEquals(res3, false)

    -- 恢复
    protocol.retimer_write = function()
        return true, true
    end

    -- 异常分支2
    protocol.retimer_loop_read = function(obj)
        return false, false
    end
    local res5, _ = test.fun(protocol, reg)
    lu.assertEquals(res5, false)

    -- 恢复
    protocol.retimer_loop_read = function()
        return true, true
    end

    -- 异常分支3
    protocol.retimer_read = function(obj)
        return false, false
    end
    local res7, _ = test.fun(protocol, reg)
    lu.assertEquals(res7, false)

    -- 恢复
    protocol.retimer_read = function()
        return true, true
    end
end

function TestRetimerAgentCS81532Utils:test_version()
    local test = utils.PARAMETERS_INHERENT['FirmwareVersion']
    local reg = {
        ['0'] = {change_mode = 0x00000f00,get_temp = 444},
        ['1'] = {change_mode = 0x00000f00,get_temp = 555},
        ena_reg = 1,
        use_pec = false
    }
    local protocol = {}
    protocol.retimer_read = function()
        return true, true
    end
    local res1, _ = test.fun(protocol, reg)
    lu.assertEquals(res1, true)

    -- 异常分支
    protocol.retimer_read = function()
        return false, false
    end
    local res3, _ = test.fun(protocol, reg)
    lu.assertEquals(res3, false)

    res3 = test.callback("3221655216")
    lu.assertEquals(res3, "06.8E.B0.30")

end