-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local std_smbus = require 'protocol.std_smbus'
local lu = require 'luaunit'

local LENGTH<const> = 20
local STATUS_DATA<const> = 5

TestStdSmbus = {}


function TestStdSmbus:test_SetLLDPStatus()
    std_smbus._send_and_receive_request_in_frames = function()
        return "\x01\x02"
    end
    local ret = std_smbus:SetLLDPStatus(STATUS_DATA)
    lu.assertEquals(ret, "\x01\x02")
end

function TestStdSmbus:test_GetLLDPStatus()
    std_smbus._send_and_receive_request_in_frames = function()
        return "\x01\x02"
    end
    std_smbus.buffer_len = LENGTH
    local ret = std_smbus:GetLLDPStatus()
    lu.assertEquals(ret.type, 1)
    lu.assertEquals(ret.status, 2)
end