-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local mcu_upg_exe = require 'mcu.upgrade.mcu_upg_exe'
local MCU_ENUMS = require 'mcu.enum.mcu_enums'
local utils = require 'mc.utils'
local upgrade_object = require 'mcu.upgrade.upgrade_object'
local fructl = require 'mcu.upgrade.fructl_handler'
local fw_mgmt = require 'general_hardware.client'
local skynet = require 'skynet'

TestMcuUpgExe = {}

local mcu_upg_inst = mcu_upg_exe.new(bus, {}, {})

-- 测试是否需要生效vrd判断函数
function TestMcuUpgExe:test_is_need_active_vrd()
    local cache_tab = {}
    local ret = mcu_upg_inst:is_need_active_vrd(cache_tab)
    lu.assertEquals(ret, false)

    cache_tab = {[2] = true}
    ret = mcu_upg_inst:is_need_active_vrd(cache_tab)
    lu.assertEquals(ret, true)
end

-- 测试升级对象插入list
function TestMcuUpgExe:test_insert_upgrade_list()
    local stub_uprgade_list = {}
    local stub_type = MCU_ENUMS.SUB_COMPONENT_TYPE.T_VRD
    local stub_mcu_obj = {
        mcu = {SubCompList = {}},
        get_system_id = function ()
            return 1
        end
    }
    local stub_mcu_sys_id = 1
    upgrade_object.new = function () return setmetatable({}, upgrade_object) end
    upgrade_object.set_ref_mcu = function () end
    upgrade_object.set_ref_subcomp = function () end
    fructl.get_power_status = function ()
        return 'OFF'
    end
    fructl.set_poweron_lock_until_success = function () end
    mcu_upg_inst:insert_upgrade_list(stub_uprgade_list, stub_type, stub_mcu_obj, stub_mcu_sys_id)
    lu.assertEquals(utils.table_compare(mcu_upg_inst.poweron_lock_list, {[1] = true}), true)
end

-- 测试解除上电锁
function TestMcuUpgExe:test_poweron_unlock()
    mcu_upg_inst:poweron_unlock()
    lu.assertEquals(utils.table_compare(mcu_upg_inst.poweron_lock_list, {}), true)
end

--测试升级任务
function TestMcuUpgExe:test_upgrade_task()
    local old_get_upgrade_list = mcu_upg_inst.get_upgrade_list
    mcu_upg_inst.get_upgrade_list = function()
        local upgrade_list = {
            [1] = {
                chip_lock_supported = function()
                    return true
                end,
                chip_lock = function()
                    return true, 0
                end,
                chip_unlock = function()
                    return true
                end,
                get_ref_subcomp = function()
                end
            }
        }
        return upgrade_list
    end
    fw_mgmt.UpdateServiceUpdateServiceUpdateUpgradeStatus = function()
    end
    utils.secure_tar_unzip = function()
    end
    skynet.fork_once = function(cb)
        return cb()
    end

    local ok, err , is_need_active_vrd = pcall(mcu_upg_inst.upgrade_task,
        mcu_upg_inst, 255, 'Mcu', '/dev/shm/upgrad/valid/123456/firmware1')
    lu.assertEquals(ok, true)
    lu.assertEquals(err, -1)
    lu.assertEquals(is_need_active_vrd, false)
    mcu_upg_inst.get_upgrade_list = old_get_upgrade_list
end