-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local upgrade_object = require 'mcu.upgrade.upgrade_object'
local smc_inte = require 'mcu.upgrade.smc_interface'
local smc_mcu_object = require 'mcu.smc_mcu_object'
local json = require 'cjson'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'

local mcu_obj = {
    mcu = {
        Id = 'mcu1',
        RefChip = {},
        LockChip = {},
        Protocol = {}
    },
    device_name = 'CpuBoard1',
    name = 'mcu1'
}
local new_upgrade_object = upgrade_object.new(mcu_obj, 1, 'OFF')

TestMcuObject = {}

local old_function = {}
local function stub_upgrade_object(board_type)
    old_function.get_ref_mcu = new_upgrade_object.get_ref_mcu
    new_upgrade_object.get_ref_mcu = function ()
        return {
            get_board_type = function () return board_type end,
            interface = smc_inte
        }
    end

    old_function.get_ref_subcomp = new_upgrade_object.get_ref_subcomp
    new_upgrade_object.get_ref_subcomp = function ()
        return {Vendor = 0, Type = 0, Delay = 10}
    end
end

function TestMcuObject:test_mcu_before_upgrade_info()
    stub_upgrade_object('ACU')
    local result = new_upgrade_object:reset_mcu_before_upgrade(3)
    lu.assertEquals(result, -1)
    new_upgrade_object.get_ref_mcu = old_function.get_ref_mcu
    new_upgrade_object.get_ref_subcomp = old_function.get_ref_subcomp
end

function TestMcuObject:test_upgrade_effect_process_info()
    local pre_fun = new_upgrade_object.take_upgrade_effect
    new_upgrade_object.take_upgrade_effect = function (...)
        return true
    end
    local fw_info = {fw_obj = {id = 'MCU'}, fw_index = 1}
    local result = new_upgrade_object:upgrade_effect_process(fw_info)
    lu.assertEquals(result, true)
    new_upgrade_object.take_upgrade_effect = pre_fun
end

function TestMcuObject:test_upgrade_process_info()
    local dir = {}
    local process_callback = "process_callback"
    local fw_info = {fw_obj = {id = 'MCU'}, fw_index = 1}
    local result new_upgrade_object:upgrade_process(dir, fw_info, process_callback)
    lu.assertEquals(result, nil)
end

function TestMcuObject:test_start_reset_mcu_info()
    local pre_fun = smc_inte.blkwrite
    smc_inte.blkwrite = function (...)
        return false
    end
    local result = smc_inte:start_reset_mcu()
    lu.assertEquals(result, false)
    smc_inte.blkwrite = pre_fun
end

function TestMcuObject:test_get_vrd_log_in_init()
    local g = smc_mcu_object.get_vrd_log
    smc_mcu_object.get_vrd_log = function()
        return {"1", "2"}
    end
    local ok = pcall(smc_mcu_object.get_vrd_log_in_init, smc_mcu_object)
    lu.assertEquals(ok, true)
    smc_mcu_object.get_vrd_log = g
end

function TestMcuObject:test_get_vrd_log1()
local VRD_DUMP_FILE_PATH<const> = '/data/var/log/vrd/'
    local i = smc_mcu_object.mcu
    smc_mcu_object.mcu = {
        Id = 123
    }
    local f = file_sec.open_s
    file_sec.open_s = function(file_name, test)
        return file_name, 1
    end
    local c = utils.close
    utils.close =function(file, ...)
        return 'abc'
    end
    local ok = pcall(smc_mcu_object.get_vrd_log, smc_mcu_object)
    lu.assertEquals(ok, false)
    smc_mcu_object.mcu = i
    file_sec.open_s = f
    utils.close =c
end
function TestMcuObject:test_get_vrd_log2()
local VRD_DUMP_FILE_PATH<const> = '/data/var/log/vrd/'
    local i = smc_mcu_object.mcu
    smc_mcu_object.mcu = {
        Id = 123
    }
    local f = file_sec.open_s
    file_sec.open_s = function(file_name, test)
        return file_name, 1
    end
    local c = utils.close
    utils.close =function(file, ...)
        return ''
    end
    local ok = pcall(smc_mcu_object.get_vrd_log, smc_mcu_object)
    lu.assertEquals(ok, true)
    smc_mcu_object.mcu = i
    file_sec.open_s = f
    utils.close =c
end

function TestMcuObject:test_get_vrd_dump_info()
    local info = {
        get_vrd_dump = function()
            return {'1'}, 1
        end
    }
    smc_mcu_object.mcu = {
        Id = 123
    }
    smc_mcu_object.interface = info
    local i = smc_mcu_object.mcu
    local f = file_sec.open_s
    file_sec.open_s = function(file_name, test)
        return false, 1
    end
    local c = utils.close
    utils.close = function(file, ...)
        return
    end
    local ok = pcall(smc_mcu_object.get_vrd_dump_info, smc_mcu_object)
    lu.assertEquals(ok, true)
    smc_mcu_object.mcu = i
    file_sec.open_s = f
    utils.close = c
end