-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local gpu_service = require 'gpu_service.gpu_service'
require 'hardware_config.Tesla_T4'

TestGpuService = {}

function TestGpuService:test_on_dump_gpu_info()
    local file = {
        write = function()
            return true
        end
    }
    local obj_set = {
        {
            gpu = {
                Slot = 1,
                Name = 'tesla t4',
                Manufacturer = 'nvidia',
                SerialNumber = '123456',
                FirmwareVersion = '1.0.0',
                SingleBitErrorPageCount = 0,
                DoubleBitErrorPageCount = 0
            },
            Capability0 = 0,
            Capability1 = 0,
            Capability2 = 0,
            Capability3 = 0
        },
        {
            gpu = {
                Slot = 1,
                Name = 'DC1000',
                Manufacturer = 'NA',
                SerialNumber = '123456',
                FirmwareVersion = '1.0.0'
            }
        }
    }
    local ok = pcall(gpu_service.on_dump_gpu_info, gpu_service, file, obj_set, 'GPU board Info\n')
    lu.assertEquals(ok, true)
end

function TestGpuService:test_update_total_power()
    gpu_service.gpu_metrics = {ConsumedPowerWatt = 0}
    local gpu = {['PowerWatts'] = 10}
    pcall(gpu_service.update_total_power, gpu_service)
    lu.assertEquals( gpu_service.gpu_metrics['ConsumedPowerWatt'], 0)
    gpu_service.gpu_collection = {{gpu = gpu}}
    pcall(gpu_service.update_total_power, gpu_service)
    lu.assertEquals( gpu_service.gpu_metrics['ConsumedPowerWatt'], 10)
end

function TestGpuService:test_on_delete_object()
    pcall(gpu_service.on_delete_object, gpu_service, 'GPUs', 'mds_obj', 'position')
    lu.assertEquals(nil, gpu_service.gpu_metrics)
end

function TestGpuService:test_on_add_object()
    local obj = {name = 'name'}
    pcall(gpu_service.on_add_object, gpu_service, 'GPUs', obj, 'position')
    lu.assertEquals(obj, gpu_service.gpu_metrics)
end