-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local dpu_object = require 'dpu_service.dpu_object'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'

Testlog = {}

local get_sub_objects = mdb.get_sub_objects
local inner = dpu_object.inner

local rsp = {
    fold = function (_, cb)
        cb()
    end
}

function Testlog:setUp()
    mdb.get_sub_objects = function (...)
        return rsp
    end
    dpu_object.inner = {
        SerialRecordConnect = {}
    }
end

function Testlog:teardown()
    mdb.get_sub_objects = get_sub_objects
    dpu_object.inner = inner
end

function Testlog:test_get_serial_mgmt_objects()
    dpu_object.get_serial_record_connections(dpu_object)
end