-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local lu = require 'luaunit'
local log = require 'mc.logging'
local cmn = require 'common'
local mdb = require 'mc.mdb'

local test_mcu_log = {}

local function test_mcu_log_dump_test(bus)
    local interface = "bmc.kepler.Systems.FruCtrl"
    local ok, fructrl
    for i = 1, 100 do
        ok, fructrl = pcall(mdb.get_object, bus, '/bmc/kepler/Systems/0/FruCtrl/FruCtrl_1_01', interface)
        if ok then
            log:notice('get fructrl[%s] success,SysResetDetected = %s', i, fructrl.SysResetDetected)
            goto continue
        end
        cmn.skynet.sleep(100)
    end
    ::continue::
    fructrl.GracefulShutdownTimeoutEnabled = 1
    cmn.skynet.sleep(100)
    lu.assertEquals(fructrl.SysResetDetected, 1)
    fructrl.GracefulShutdownTimeoutEnabled = 0
    cmn.skynet.sleep(100)
    lu.assertEquals(fructrl.SysResetDetected, 0)
end

function test_mcu_log.main(bus)
    log:notice('================ test mcu log start ================')
    test_mcu_log_dump_test(bus)
    log:notice('================ test mcu log complete ================')
end

return test_mcu_log
