-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: GPU资源集成测试用例
local lu = require 'luaunit'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local skynet = require 'skynet'
local GENERAL_HARDWARE_SERVICE = 'bmc.kepler.general_hardware'
local PROCESSOR_INTERFACE = 'bmc.kepler.Systems.Processor'
local PROCESSOR_INVENTORY_INTERFACE = 'bmc.kepler.Inventory.Hardware'
local DBUS_INTERFACE = 'org.freedesktop.DBus.Properties'
local GPU_PATH = '/bmc/kepler/Systems/1/Processors/GPU'


local test_gpu = {}

local mdb_service = require 'mc.mdb.mdb_service'

-- 使用sdbus接口获取指定路径下所有对象路径
local function get_object_path(bus, path)
    local rsp = mdb_service.get_sub_paths(bus,  path, 1, {})
    return rsp.SubPaths
end

-- 使用sdbus接口读取树上GPU对象全部属性
local function get_gpu_property(bus, path, interface)
    return bus:call(GENERAL_HARDWARE_SERVICE, path, DBUS_INTERFACE, 'GetAll', 's', interface)
end

-- 测试树上gpu的资源
local function test_gpu_on_tree(bus)
    local gpu_path_list = get_object_path(bus, GPU_PATH)
    for _, v in pairs(gpu_path_list) do
        local gpu = get_gpu_property(bus, v, PROCESSOR_INTERFACE)
        lu.assertEquals(gpu.SystemId:value(), 1)
        lu.assertEquals(gpu.Presence:value(), 1)
        lu.assertEquals(gpu.Id:value(), 1)
        lu.assertEquals(gpu.Name:value(), 'Quadro P6000')
        lu.assertEquals(gpu.Manufacturer:value(), 'NVIDIA Corporation')
        lu.assertEquals(gpu.Model:value(), 'Quadro P6000')
        lu.assertEquals(gpu.SN:value(), '')
        lu.assertEquals(gpu.SocketDesignation:value(), '1')
        lu.assertEquals(gpu.Position:value(), 'PCIe Riser1')
        local gpu_inventory = get_gpu_property(bus, v, PROCESSOR_INVENTORY_INTERFACE)
        lu.assertEquals(gpu_inventory.AssetType:value(), 'PCIe GPU Card')
        lu.assertEquals(gpu_inventory.PCBVersion:value(), 'N/A')
        lu.assertEquals(gpu_inventory.Manufacturer:value(), 'NVIDIA Corporation')
        
    end
    
end

function test_gpu.main(bus)
    skynet.sleep(500)
    test_gpu_on_tree(bus)
end

return test_gpu