-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local RETIMER_CONSTANTS = {}

RETIMER_CONSTANTS.CHIP_TYPE = {
    TYPE_5902L = 0,
    TYPE_5902H = 1,
    TYPE_5901 = 2,
    TYPE_M88RT51632 = 6,
    TYPE_CS81532 = 7
}

RETIMER_CONSTANTS.FW_TYPE = {
    FW_5902L = 0,
    FW_M88RT51632_X16 = 0x13000006,
    FW_M88RT51632_X8X8 = 0x13000106,
    FW_M88RT51632_X8X4X4 = 0x13000206,
    FW_M88RT51632_X4X4X8 = 0x13000306,
    FW_M88RT51632_X4X4X4X4 = 0x13000406,
    FW_CS81532_X16 = 0X13000007,
    FW_CS81532_X8X8 = 0X13000107,
    FW_CS81532_X8X4X4 = 0X13000207,
    FW_CS81532_X4X4X8 = 0X13000307,
    FW_CS81532_X4X4X4X4 = 0X13000407
}

RETIMER_CONSTANTS.UPGRADE_FILE_NAME =   {
    [0x13000006] = "06_8e_b0_00.bin",
    [0x13000106] = "06_8e_b0_30.bin",
    [0x13000206] = "06_8e_b0_40.bin",
    [0x13000306] = "06_8e_b0_50.bin",
    [0x13000406] = "06_8e_b0_60.bin",
    [0X13000007] = "01_0B_00_00.bin",
    [0X13000107] = "01_0B_00_03.bin",
    [0X13000407] = "01_0B_00_06.bin"
}

RETIMER_CONSTANTS.UPGRADE_RETRY_TIMES = {
    [6] = 3,
    [7] = 3
}

RETIMER_CONSTANTS.NOTIFY_STATUS = {
    IDLE = 0,
    UPGRADING = 1
}

RETIMER_CONSTANTS.CHANNEL_STATUS = {
    OPEN = 0,
    CLOSE = 1
}

RETIMER_CONSTANTS.UPGRADE_STATUS = {
    IDLE = 0,
    ON_GOING = 1,
    DONE = 2,
    VALID = 3
}

return RETIMER_CONSTANTS
