-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local common = class()

function common:ctor()
    self.ipmi_channel_config = {}
end

local on_add_object_switch = {
    VrdIPMIChannelConfig = function(app, class_name, object, position)
        common:on_add_VrdIPMIChannelConfig_object(class_name, object, position)
    end
}

function common:on_add_VrdIPMIChannelConfig_object(class_name, object, position)
    self.ipmi_channel_config = {}
    for _, c in ipairs(object.Maps) do
        local system_id, socket_id, instance = table.unpack(c)
        log:notice('VrdIPMIChannelConfig: system_id = %s, socket_id = %s, instance = %s',
            system_id, socket_id, instance)
        local obj = self.ipmi_channel_config
        if not obj[system_id] then
            obj[system_id] = {
                [socket_id] = instance
            }
            goto continue
        end

        if not obj[system_id][socket_id] then
            obj[system_id][socket_id] = instance
        end
        ::continue::
        log:notice('VrdIPMIChannelConfig: value = %s', self.ipmi_channel_config[system_id][socket_id])
    end
end

function common:on_add_object(class_name, object, position)
    if on_add_object_switch[class_name] then
        on_add_object_switch[class_name](self, class_name, object, position)
    end
end

function common:get_channel_id(sys_id, socket_id)
    local obj = self.ipmi_channel_config
    if not obj or not obj[sys_id] or not obj[sys_id][socket_id] then
        return 0
    end
    return obj[sys_id][socket_id]
end

return singleton(common)