-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local defs = require 'mcu.upgrade.defs'
local upgrade_service_mcu = require 'mcu.upgrade.upgrade_service.upgrade_service_mcu'
local upgrade_service_vrd = require 'mcu.upgrade.upgrade_service.upgrade_service_vrd'

local upgrade_service_object = {}
upgrade_service_object.__index = upgrade_service_object

function upgrade_service_object.new()
    return setmetatable({}, upgrade_service_object)
end

function upgrade_service_object:get_upgrade_service_obj(firmware_type)
    log:debug('get upgrade service obj: firmware_type = %s', firmware_type)
    local upgrade_service_obj_switch = {
        [defs.firmware_type.MCU] = upgrade_service_mcu.get_instance(),
        [defs.firmware_type.VRD] = self.vrd_upgrade_service,
        [defs.firmware_type.VDM] = self.vrd_upgrade_service
    }
    local upgrade_service_obj = upgrade_service_obj_switch[firmware_type]
    if not upgrade_service_obj then
        log:error('unknown firmware type [%s].', firmware_type)
        return
    end
    return upgrade_service_obj
end

function upgrade_service_object:init_upgrade_service_obj(bus, db, mcu_collection)
    log:notice('init upgrade service obj')
    upgrade_service_mcu.new(bus, db, mcu_collection)
    self.vrd_upgrade_service = upgrade_service_vrd.new(bus, db, mcu_collection)
end

return singleton(upgrade_service_object)
