-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 配置导入导出
local log = require 'mc.logging'
local json = require 'cjson'
local base_messages = require 'messages.base'
local customize_cfg_handler = require 'customize_cfg'
local factory = require 'factory'

local import_export = {}

local CONFIG_DATA = "ConfigData"
local TYPE_CONFIG = 'configuration'

local function get_config(config_string)
    local ok, bmc_config_json = pcall(function()
        return json.decode(config_string)
    end)
    if not ok or bmc_config_json == nil then
        log:error("[general_hardware]import general_hardware json: json format error")
        error(base_messages.MalformedJSON())
    end
    return bmc_config_json[CONFIG_DATA]
end


function import_export.import(ctx, cfg_data, import_type, db)
    -- 配置导入直接返回
    if import_type == TYPE_CONFIG then
        return
    end

    -- 定制导入
    local config = get_config(cfg_data)
    customize_cfg_handler.config_import_data(config, db)
end

function import_export.export(ctx, export_type, db)
    -- 配置导出直接返回
    if export_type == TYPE_CONFIG then
        return ''
    end

    -- 定制导出
    local final_config = {}
    final_config[CONFIG_DATA] = {}
    customize_cfg_handler.config_export_data(final_config[CONFIG_DATA], db)
    local ok, user_config_data = pcall(function()
        return json.encode(final_config)
    end)
    if not ok or user_config_data == nil then
        log:error("[general_hardware]export general_hardware config: general_hardware json config is nil")
        error(base_messages.MalformedJSON())
    end
    return user_config_data
end
local function no_hddbackplane()
    local unit_manager = factory.get_obj("unit_manager")
    if unit_manager.hdd_backplanes[1] == nil then
        return true
    end
    return false
end

local function no_configed(import_data)
    if import_data.DiskSlotCustomize.Value ~= 'on' or import_data.DiskSlotCustomizeId.Value ~= 'Tencent' then
        return true
    end
    return false
end

function import_export.verify(ctx, config_data)
    local ok, import_data = pcall(function ()
        local data = json.decode(config_data)
        return data.Components.general_hardware.ConfigData.CustomSettings
    end)
    if not ok then
        log:error('Get import data failed:%s', import_data)
        return ''
    end

    local result = {}
    if no_hddbackplane() or no_configed(import_data) then
        result['DiskSlotCustomize'] = {Value='', Result='none'}
        result['DiskSlotCustomizeId'] = {Value='', Result='none'}
    end

    return json.encode(result)
end

return import_export