-- Copyright (c) 2025 Henan Kunlun Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local utils = require 'mc.utils'

local Nvidia = {
    protocol_dependencies = { smbus_postbox = { ref_chip = nil, buffer_len = 32, data_reg_addr = 0x5d } },
    properties = {
        FirmwareVersion = {
            protocol = 'smbus_postbox',
            action = 'on_schedule',
            period_in_sec = 10,
            request = {
                name = 'CardFirmVer',
                opcode = 0x5,
                arg1 = 0x8,
                capa_dword_num = 1,
                capa_mask = 0x00000100,
                data_out = 1,
                data_len = 14,
                data_type = 1
            },
            response = function(data)
                return data
            end
        },
        SN = {
            protocol = 'smbus_postbox',
            action = 'on_schedule',
            period_in_sec = 10,
            request = {
                name = 'CardSN',
                opcode = 0x5,
                arg1 = 0x2,
                capa_dword_num = 1,
                capa_mask = 0x00000004,
                data_out = 1,
                data_len = 16,
                data_type = 1
            },
            response = function(data)
                return data
            end
        },
        -- 依赖驱动
        PowerWatts = {
            protocol = 'smbus_postbox',
            action = 'on_schedule',
            period_in_sec = 2,
            request = {
                name = 'CardPower',
                opcode = 0x4,
                arg1 = 0x0,
                arg2 = 0x0,
                capa_dword_num = 0,
                capa_mask = 0x00010000,
                data_out = 1,
                data_len = 4,
                data_type = 0,
                data_mask = 0xffffffff
            },
            response = function(data)
                return tonumber(data) // 1000
            end
        },
        RetiredPage = {
            protocol = 'smbus_postbox',
            action = 'on_schedule',
            period_in_sec = 2,
            request = {
                name = 'CardRetiredPage',
                opcode = 0x13,
                arg1 = 0x0,
                arg2 = 0x0,
                capa_dword_num = 1,
                capa_mask = 0x00080000,
                data_out = 1,
                data_len = 4,
                data_type = 0,
                data_mask = 0x0000ffff
            },
            response = function(data)
                return tonumber(data)
            end
        }
    }
}

return {
    smbus_postbox = function(ref_chip)
        local obj = utils.table_copy(Nvidia)
        obj.protocol_dependencies.smbus_postbox.ref_chip = ref_chip
        return obj
    end
}