-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local comm_defs = {}

-- GPU卡相关设备树接口
-- PCIeGpuCard
comm_defs.PCIE_DEVICE_INTERFACE = 'bmc.dev.PCIeDevice'
comm_defs.PCIE_CARD_INTERFACE = 'bmc.dev.PCIeCard'
-- Gpu
comm_defs.PROCESSOR_INTERFACE = 'bmc.dev.Processor'
comm_defs.GPU_INTERFACE = 'bmc.dev.Gpu'
comm_defs.GPU_POWER_INTERFACE = 'bmc.dev.Gpu.Power'
comm_defs.GPU_STATUS_INTERFACE = 'bmc.dev.Gpu.Status'
-- Memory
comm_defs.MEMORY_INTERFACE = 'bmc.dev.Memory'

comm_defs.GPU_CLASS_NAME = 'GPU'
comm_defs.POSITION_INDEX = 4

comm_defs.MACA_SERVICE = 'bmc.kepler.maca'
comm_defs.MDB_PATH = '/bmc/kepler/MdbService'
comm_defs.MDB_INTERFACE = 'bmc.kepler.Mdb'
comm_defs.OBJECT_PROPERTIES_INTERFACE = 'bmc.kepler.Object.Properties'
comm_defs.ORG_PROPERTIES_INTERFACE = 'org.freedesktop.DBus.Properties'

comm_defs.PCIE_GPU_CARD_DEVICE_PATH_PATTERN = '/bmc/dev/Systems/1/PCIeGpuCard'
comm_defs.GPU_SUFFIX = '/Gpu/1'
comm_defs.MEMORY_SUFFIX = '/Memory/1'

return comm_defs
