-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
--

-- Description: 添加事件接口
local log = require 'mc.logging'
local cjson = require 'cjson'
local event = require 'infrastructure.event'

local add_event = {}

function add_event.generate_mcu_error_code(bus, err_code, assert, slot_id, name, event_key_id, event_desc_en, com_name,
    fru_type)
    local err_code_str = "Error Code: " .. err_code
    local name_str = "(" .. name .. ")"
    local param = {}
    param[#param + 1] = { 'ComponentName', com_name }
    param[#param + 1] = { 'State', assert }
    param[#param + 1] = { 'EventKeyId', event_key_id } -- MCU故障码对应的EventKeyId
    param[#param + 1] = { 'MessageArgs', cjson.encode({ slot_id, name_str, event_desc_en, err_code_str }) }
    param[#param + 1] = { 'SystemId', '1' }
    param[#param + 1] = { 'ManagerId', '1' }
    param[#param + 1] = { 'ChassisId', '1' }
    param[#param + 1] = { 'NodeId', '' }
    param[#param + 1] = { 'SubjectType', tostring(fru_type) }

    local ok, ret = pcall(event.generate_event, param)
    if ok then
        log:notice('add event successfully')
    else
        log:error('add event failed, %s', ret)
    end
end

return add_event
