-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local VrdPower = {}

---@class VrdPower.TemperatureCelsius
---@field TemperatureCelsius number
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj VrdPower.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'double', true, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

VrdPower.TemperatureCelsius = TTemperatureCelsius

---@class VrdPower.CurrentAmps
---@field CurrentAmps number
local TCurrentAmps = {}
TCurrentAmps.__index = TCurrentAmps
TCurrentAmps.group = {}

local function TCurrentAmps_from_obj(obj)
    return setmetatable(obj, TCurrentAmps)
end

function TCurrentAmps.new(CurrentAmps)
    return TCurrentAmps_from_obj({CurrentAmps = CurrentAmps})
end
---@param obj VrdPower.CurrentAmps
function TCurrentAmps:init_from_obj(obj)
    self.CurrentAmps = obj.CurrentAmps
end

function TCurrentAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentAmps.group)
end

TCurrentAmps.from_obj = TCurrentAmps_from_obj

TCurrentAmps.proto_property = {'CurrentAmps'}

TCurrentAmps.default = {0}

TCurrentAmps.struct = {{name = 'CurrentAmps', is_array = false, struct = nil}}

function TCurrentAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentAmps', self.CurrentAmps, 'double', true, errs, need_convert)

    TCurrentAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentAmps.proto_property, errs, need_convert)
    return self
end

function TCurrentAmps:unpack(_)
    return self.CurrentAmps
end

VrdPower.CurrentAmps = TCurrentAmps

---@class VrdPower.Voltage
---@field Voltage number
local TVoltage = {}
TVoltage.__index = TVoltage
TVoltage.group = {}

local function TVoltage_from_obj(obj)
    return setmetatable(obj, TVoltage)
end

function TVoltage.new(Voltage)
    return TVoltage_from_obj({Voltage = Voltage})
end
---@param obj VrdPower.Voltage
function TVoltage:init_from_obj(obj)
    self.Voltage = obj.Voltage
end

function TVoltage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVoltage.group)
end

TVoltage.from_obj = TVoltage_from_obj

TVoltage.proto_property = {'Voltage'}

TVoltage.default = {0}

TVoltage.struct = {{name = 'Voltage', is_array = false, struct = nil}}

function TVoltage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Voltage', self.Voltage, 'double', true, errs, need_convert)

    TVoltage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVoltage.proto_property, errs, need_convert)
    return self
end

function TVoltage:unpack(_)
    return self.Voltage
end

VrdPower.Voltage = TVoltage

---@class VrdPower.DieId
---@field DieId integer
local TDieId = {}
TDieId.__index = TDieId
TDieId.group = {}

local function TDieId_from_obj(obj)
    return setmetatable(obj, TDieId)
end

function TDieId.new(DieId)
    return TDieId_from_obj({DieId = DieId})
end
---@param obj VrdPower.DieId
function TDieId:init_from_obj(obj)
    self.DieId = obj.DieId
end

function TDieId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDieId.group)
end

TDieId.from_obj = TDieId_from_obj

TDieId.proto_property = {'DieId'}

TDieId.default = {0}

TDieId.struct = {{name = 'DieId', is_array = false, struct = nil}}

function TDieId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DieId', self.DieId, 'uint8', true, errs, need_convert)

    TDieId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDieId.proto_property, errs, need_convert)
    return self
end

function TDieId:unpack(_)
    return self.DieId
end

VrdPower.DieId = TDieId

---@class VrdPower.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj VrdPower.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

VrdPower.Type = TType

---@class VrdPower.CpuId
---@field CpuId integer
local TCpuId = {}
TCpuId.__index = TCpuId
TCpuId.group = {}

local function TCpuId_from_obj(obj)
    return setmetatable(obj, TCpuId)
end

function TCpuId.new(CpuId)
    return TCpuId_from_obj({CpuId = CpuId})
end
---@param obj VrdPower.CpuId
function TCpuId:init_from_obj(obj)
    self.CpuId = obj.CpuId
end

function TCpuId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuId.group)
end

TCpuId.from_obj = TCpuId_from_obj

TCpuId.proto_property = {'CpuId'}

TCpuId.default = {0}

TCpuId.struct = {{name = 'CpuId', is_array = false, struct = nil}}

function TCpuId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuId', self.CpuId, 'uint8', true, errs, need_convert)

    TCpuId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuId.proto_property, errs, need_convert)
    return self
end

function TCpuId:unpack(_)
    return self.CpuId
end

VrdPower.CpuId = TCpuId

---@class VrdPower.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj VrdPower.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

VrdPower.SystemId = TSystemId

VrdPower.interface = mdb.register_interface('bmc.kepler.Systems.VrdPower', {
    SystemId = {'y', nil, true, nil, false},
    CpuId = {'y', nil, true, nil, false},
    Type = {'y', nil, true, nil, false},
    DieId = {'y', nil, true, nil, false},
    Voltage = {'d', {'EMIT_CHANGE'}, true, nil, false},
    CurrentAmps = {'d', {'EMIT_CHANGE'}, true, nil, false},
    TemperatureCelsius = {'d', {'EMIT_CHANGE'}, true, nil, false}
}, {}, {})

return VrdPower
