-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SerialManagement = {}

---@class SerialManagement.DestSerial
---@field DestSerial integer
local TDestSerial = {}
TDestSerial.__index = TDestSerial
TDestSerial.group = {}

local function TDestSerial_from_obj(obj)
    return setmetatable(obj, TDestSerial)
end

function TDestSerial.new(DestSerial)
    return TDestSerial_from_obj({DestSerial = DestSerial})
end
---@param obj SerialManagement.DestSerial
function TDestSerial:init_from_obj(obj)
    self.DestSerial = obj.DestSerial
end

function TDestSerial:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDestSerial.group)
end

TDestSerial.from_obj = TDestSerial_from_obj

TDestSerial.proto_property = {'DestSerial'}

TDestSerial.default = {0}

TDestSerial.struct = {{name = 'DestSerial', is_array = false, struct = nil}}

function TDestSerial:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DestSerial', self.DestSerial, 'uint8', true, errs, need_convert)

    TDestSerial:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDestSerial.proto_property, errs, need_convert)
    return self
end

function TDestSerial:unpack(_)
    return self.DestSerial
end

SerialManagement.DestSerial = TDestSerial

---@class SerialManagement.SrcSerial
---@field SrcSerial integer
local TSrcSerial = {}
TSrcSerial.__index = TSrcSerial
TSrcSerial.group = {}

local function TSrcSerial_from_obj(obj)
    return setmetatable(obj, TSrcSerial)
end

function TSrcSerial.new(SrcSerial)
    return TSrcSerial_from_obj({SrcSerial = SrcSerial})
end
---@param obj SerialManagement.SrcSerial
function TSrcSerial:init_from_obj(obj)
    self.SrcSerial = obj.SrcSerial
end

function TSrcSerial:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSrcSerial.group)
end

TSrcSerial.from_obj = TSrcSerial_from_obj

TSrcSerial.proto_property = {'SrcSerial'}

TSrcSerial.default = {0}

TSrcSerial.struct = {{name = 'SrcSerial', is_array = false, struct = nil}}

function TSrcSerial:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SrcSerial', self.SrcSerial, 'uint8', true, errs, need_convert)

    TSrcSerial:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSrcSerial.proto_property, errs, need_convert)
    return self
end

function TSrcSerial:unpack(_)
    return self.SrcSerial
end

SerialManagement.SrcSerial = TSrcSerial

---@class SerialManagement.Destination
---@field Destination string
local TDestination = {}
TDestination.__index = TDestination
TDestination.group = {}

local function TDestination_from_obj(obj)
    return setmetatable(obj, TDestination)
end

function TDestination.new(Destination)
    return TDestination_from_obj({Destination = Destination})
end
---@param obj SerialManagement.Destination
function TDestination:init_from_obj(obj)
    self.Destination = obj.Destination
end

function TDestination:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDestination.group)
end

TDestination.from_obj = TDestination_from_obj

TDestination.proto_property = {'Destination'}

TDestination.default = {''}

TDestination.struct = {{name = 'Destination', is_array = false, struct = nil}}

function TDestination:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Destination', self.Destination, 'string', true, errs, need_convert)

    TDestination:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDestination.proto_property, errs, need_convert)
    return self
end

function TDestination:unpack(_)
    return self.Destination
end

SerialManagement.Destination = TDestination

---@class SerialManagement.Source
---@field Source string
local TSource = {}
TSource.__index = TSource
TSource.group = {}

local function TSource_from_obj(obj)
    return setmetatable(obj, TSource)
end

function TSource.new(Source)
    return TSource_from_obj({Source = Source})
end
---@param obj SerialManagement.Source
function TSource:init_from_obj(obj)
    self.Source = obj.Source
end

function TSource:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSource.group)
end

TSource.from_obj = TSource_from_obj

TSource.proto_property = {'Source'}

TSource.default = {''}

TSource.struct = {{name = 'Source', is_array = false, struct = nil}}

function TSource:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Source', self.Source, 'string', true, errs, need_convert)

    TSource:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSource.proto_property, errs, need_convert)
    return self
end

function TSource:unpack(_)
    return self.Source
end

SerialManagement.Source = TSource

---@class SerialManagement.CurrentConnectStatus
---@field CurrentConnectStatus integer
local TCurrentConnectStatus = {}
TCurrentConnectStatus.__index = TCurrentConnectStatus
TCurrentConnectStatus.group = {}

local function TCurrentConnectStatus_from_obj(obj)
    return setmetatable(obj, TCurrentConnectStatus)
end

function TCurrentConnectStatus.new(CurrentConnectStatus)
    return TCurrentConnectStatus_from_obj({CurrentConnectStatus = CurrentConnectStatus})
end
---@param obj SerialManagement.CurrentConnectStatus
function TCurrentConnectStatus:init_from_obj(obj)
    self.CurrentConnectStatus = obj.CurrentConnectStatus
end

function TCurrentConnectStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentConnectStatus.group)
end

TCurrentConnectStatus.from_obj = TCurrentConnectStatus_from_obj

TCurrentConnectStatus.proto_property = {'CurrentConnectStatus'}

TCurrentConnectStatus.default = {0}

TCurrentConnectStatus.struct = {{name = 'CurrentConnectStatus', is_array = false, struct = nil}}

function TCurrentConnectStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentConnectStatus', self.CurrentConnectStatus, 'uint8', true, errs, need_convert)

    if self.CurrentConnectStatus ~= nil then
        validate.Enum(prefix .. 'CurrentConnectStatus', self.CurrentConnectStatus, '', {0, 1}, errs, need_convert)
    end

    TCurrentConnectStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentConnectStatus.proto_property, errs, need_convert)
    return self
end

function TCurrentConnectStatus:unpack(_)
    return self.CurrentConnectStatus
end

SerialManagement.CurrentConnectStatus = TCurrentConnectStatus

---@class SerialManagement.Availability
---@field Availability integer
local TAvailability = {}
TAvailability.__index = TAvailability
TAvailability.group = {}

local function TAvailability_from_obj(obj)
    return setmetatable(obj, TAvailability)
end

function TAvailability.new(Availability)
    return TAvailability_from_obj({Availability = Availability})
end
---@param obj SerialManagement.Availability
function TAvailability:init_from_obj(obj)
    self.Availability = obj.Availability
end

function TAvailability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAvailability.group)
end

TAvailability.from_obj = TAvailability_from_obj

TAvailability.proto_property = {'Availability'}

TAvailability.default = {0}

TAvailability.struct = {{name = 'Availability', is_array = false, struct = nil}}

function TAvailability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Availability', self.Availability, 'uint8', true, errs, need_convert)

    TAvailability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAvailability.proto_property, errs, need_convert)
    return self
end

function TAvailability:unpack(_)
    return self.Availability
end

SerialManagement.Availability = TAvailability

---@class SerialManagement.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj SerialManagement.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

SerialManagement.Id = TId

---@class SerialManagement.SetConnectStatusRsp
local TSetConnectStatusRsp = {}
TSetConnectStatusRsp.__index = TSetConnectStatusRsp
TSetConnectStatusRsp.group = {}

local function TSetConnectStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetConnectStatusRsp)
end

function TSetConnectStatusRsp.new()
    return TSetConnectStatusRsp_from_obj({})
end
---@param obj SerialManagement.SetConnectStatusRsp
function TSetConnectStatusRsp:init_from_obj(obj)

end

function TSetConnectStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetConnectStatusRsp.group)
end

TSetConnectStatusRsp.from_obj = TSetConnectStatusRsp_from_obj

TSetConnectStatusRsp.proto_property = {}

TSetConnectStatusRsp.default = {}

TSetConnectStatusRsp.struct = {}

function TSetConnectStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetConnectStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetConnectStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetConnectStatusRsp:unpack(_)
end

SerialManagement.SetConnectStatusRsp = TSetConnectStatusRsp

---@class SerialManagement.SetConnectStatusReq
---@field NeedSaved boolean
local TSetConnectStatusReq = {}
TSetConnectStatusReq.__index = TSetConnectStatusReq
TSetConnectStatusReq.group = {}

local function TSetConnectStatusReq_from_obj(obj)
    return setmetatable(obj, TSetConnectStatusReq)
end

function TSetConnectStatusReq.new(NeedSaved)
    return TSetConnectStatusReq_from_obj({NeedSaved = NeedSaved})
end
---@param obj SerialManagement.SetConnectStatusReq
function TSetConnectStatusReq:init_from_obj(obj)
    self.NeedSaved = obj.NeedSaved
end

function TSetConnectStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetConnectStatusReq.group)
end

TSetConnectStatusReq.from_obj = TSetConnectStatusReq_from_obj

TSetConnectStatusReq.proto_property = {'NeedSaved'}

TSetConnectStatusReq.default = {false}

TSetConnectStatusReq.struct = {{name = 'NeedSaved', is_array = false, struct = nil}}

function TSetConnectStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NeedSaved', self.NeedSaved, 'bool', false, errs, need_convert)

    TSetConnectStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetConnectStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetConnectStatusReq:unpack(_)
    return self.NeedSaved
end

SerialManagement.SetConnectStatusReq = TSetConnectStatusReq

SerialManagement.interface = mdb.register_interface('bmc.kepler.Managers.SerialManagement', {
    Id = {'y', {}, true, nil, false},
    Availability = {'y', {}, true, nil, false},
    CurrentConnectStatus = {'y', nil, true, nil, false},
    Source = {'s', {}, true, nil, false},
    Destination = {'s', {}, true, nil, false},
    SrcSerial = {'y', {}, true, nil, false},
    DestSerial = {'y', {}, true, nil, false}
}, {SetConnectStatus = {'a{ss}b', '', TSetConnectStatusReq, TSetConnectStatusRsp}}, {})

return SerialManagement
