-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NpuBoard = {}

---@class NpuBoard.VRDUpgradeState
---@field VRDUpgradeState integer
local TVRDUpgradeState = {}
TVRDUpgradeState.__index = TVRDUpgradeState
TVRDUpgradeState.group = {}

local function TVRDUpgradeState_from_obj(obj)
    return setmetatable(obj, TVRDUpgradeState)
end

function TVRDUpgradeState.new(VRDUpgradeState)
    return TVRDUpgradeState_from_obj({VRDUpgradeState = VRDUpgradeState or 0})
end
---@param obj NpuBoard.VRDUpgradeState
function TVRDUpgradeState:init_from_obj(obj)
    self.VRDUpgradeState = obj.VRDUpgradeState or 0
end

function TVRDUpgradeState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVRDUpgradeState.group)
end

TVRDUpgradeState.from_obj = TVRDUpgradeState_from_obj

TVRDUpgradeState.proto_property = {'VRDUpgradeState'}

TVRDUpgradeState.default = {0}

TVRDUpgradeState.struct = {{name = 'VRDUpgradeState', is_array = false, struct = nil}}

function TVRDUpgradeState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VRDUpgradeState', self.VRDUpgradeState, 'uint8', true, errs, need_convert)

    TVRDUpgradeState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVRDUpgradeState.proto_property, errs, need_convert)
    return self
end

function TVRDUpgradeState:unpack(_)
    return self.VRDUpgradeState
end

NpuBoard.VRDUpgradeState = TVRDUpgradeState

---@class NpuBoard.ComputeCapability
---@field ComputeCapability string
local TComputeCapability = {}
TComputeCapability.__index = TComputeCapability
TComputeCapability.group = {}

local function TComputeCapability_from_obj(obj)
    return setmetatable(obj, TComputeCapability)
end

function TComputeCapability.new(ComputeCapability)
    return TComputeCapability_from_obj({ComputeCapability = ComputeCapability})
end
---@param obj NpuBoard.ComputeCapability
function TComputeCapability:init_from_obj(obj)
    self.ComputeCapability = obj.ComputeCapability
end

function TComputeCapability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComputeCapability.group)
end

TComputeCapability.from_obj = TComputeCapability_from_obj

TComputeCapability.proto_property = {'ComputeCapability'}

TComputeCapability.default = {''}

TComputeCapability.struct = {{name = 'ComputeCapability', is_array = false, struct = nil}}

function TComputeCapability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComputeCapability', self.ComputeCapability, 'string', true, errs, need_convert)

    TComputeCapability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComputeCapability.proto_property, errs, need_convert)
    return self
end

function TComputeCapability:unpack(_)
    return self.ComputeCapability
end

NpuBoard.ComputeCapability = TComputeCapability

---@class NpuBoard.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj NpuBoard.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

NpuBoard.Model = TModel

---@class NpuBoard.MinPowerCapWatts
---@field MinPowerCapWatts integer
local TMinPowerCapWatts = {}
TMinPowerCapWatts.__index = TMinPowerCapWatts
TMinPowerCapWatts.group = {}

local function TMinPowerCapWatts_from_obj(obj)
    return setmetatable(obj, TMinPowerCapWatts)
end

function TMinPowerCapWatts.new(MinPowerCapWatts)
    return TMinPowerCapWatts_from_obj({MinPowerCapWatts = MinPowerCapWatts})
end
---@param obj NpuBoard.MinPowerCapWatts
function TMinPowerCapWatts:init_from_obj(obj)
    self.MinPowerCapWatts = obj.MinPowerCapWatts
end

function TMinPowerCapWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinPowerCapWatts.group)
end

TMinPowerCapWatts.from_obj = TMinPowerCapWatts_from_obj

TMinPowerCapWatts.proto_property = {'MinPowerCapWatts'}

TMinPowerCapWatts.default = {0}

TMinPowerCapWatts.struct = {{name = 'MinPowerCapWatts', is_array = false, struct = nil}}

function TMinPowerCapWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinPowerCapWatts', self.MinPowerCapWatts, 'uint16', true, errs, need_convert)

    TMinPowerCapWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinPowerCapWatts.proto_property, errs, need_convert)
    return self
end

function TMinPowerCapWatts:unpack(_)
    return self.MinPowerCapWatts
end

NpuBoard.MinPowerCapWatts = TMinPowerCapWatts

---@class NpuBoard.MaxPowerCapWatts
---@field MaxPowerCapWatts integer
local TMaxPowerCapWatts = {}
TMaxPowerCapWatts.__index = TMaxPowerCapWatts
TMaxPowerCapWatts.group = {}

local function TMaxPowerCapWatts_from_obj(obj)
    return setmetatable(obj, TMaxPowerCapWatts)
end

function TMaxPowerCapWatts.new(MaxPowerCapWatts)
    return TMaxPowerCapWatts_from_obj({MaxPowerCapWatts = MaxPowerCapWatts})
end
---@param obj NpuBoard.MaxPowerCapWatts
function TMaxPowerCapWatts:init_from_obj(obj)
    self.MaxPowerCapWatts = obj.MaxPowerCapWatts
end

function TMaxPowerCapWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxPowerCapWatts.group)
end

TMaxPowerCapWatts.from_obj = TMaxPowerCapWatts_from_obj

TMaxPowerCapWatts.proto_property = {'MaxPowerCapWatts'}

TMaxPowerCapWatts.default = {0}

TMaxPowerCapWatts.struct = {{name = 'MaxPowerCapWatts', is_array = false, struct = nil}}

function TMaxPowerCapWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxPowerCapWatts', self.MaxPowerCapWatts, 'uint16', true, errs, need_convert)

    TMaxPowerCapWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxPowerCapWatts.proto_property, errs, need_convert)
    return self
end

function TMaxPowerCapWatts:unpack(_)
    return self.MaxPowerCapWatts
end

NpuBoard.MaxPowerCapWatts = TMaxPowerCapWatts

---@class NpuBoard.PowerCapWatts
---@field PowerCapWatts integer
local TPowerCapWatts = {}
TPowerCapWatts.__index = TPowerCapWatts
TPowerCapWatts.group = {}

local function TPowerCapWatts_from_obj(obj)
    return setmetatable(obj, TPowerCapWatts)
end

function TPowerCapWatts.new(PowerCapWatts)
    return TPowerCapWatts_from_obj({PowerCapWatts = PowerCapWatts})
end
---@param obj NpuBoard.PowerCapWatts
function TPowerCapWatts:init_from_obj(obj)
    self.PowerCapWatts = obj.PowerCapWatts
end

function TPowerCapWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCapWatts.group)
end

TPowerCapWatts.from_obj = TPowerCapWatts_from_obj

TPowerCapWatts.proto_property = {'PowerCapWatts'}

TPowerCapWatts.default = {0}

TPowerCapWatts.struct = {{name = 'PowerCapWatts', is_array = false, struct = nil}}

function TPowerCapWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCapWatts', self.PowerCapWatts, 'uint16', true, errs, need_convert)

    TPowerCapWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCapWatts.proto_property, errs, need_convert)
    return self
end

function TPowerCapWatts:unpack(_)
    return self.PowerCapWatts
end

NpuBoard.PowerCapWatts = TPowerCapWatts

---@class NpuBoard.PowerWatts
---@field PowerWatts integer
local TPowerWatts = {}
TPowerWatts.__index = TPowerWatts
TPowerWatts.group = {}

local function TPowerWatts_from_obj(obj)
    return setmetatable(obj, TPowerWatts)
end

function TPowerWatts.new(PowerWatts)
    return TPowerWatts_from_obj({PowerWatts = PowerWatts})
end
---@param obj NpuBoard.PowerWatts
function TPowerWatts:init_from_obj(obj)
    self.PowerWatts = obj.PowerWatts
end

function TPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerWatts.group)
end

TPowerWatts.from_obj = TPowerWatts_from_obj

TPowerWatts.proto_property = {'PowerWatts'}

TPowerWatts.default = {0}

TPowerWatts.struct = {{name = 'PowerWatts', is_array = false, struct = nil}}

function TPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerWatts', self.PowerWatts, 'uint16', true, errs, need_convert)

    TPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerWatts.proto_property, errs, need_convert)
    return self
end

function TPowerWatts:unpack(_)
    return self.PowerWatts
end

NpuBoard.PowerWatts = TPowerWatts

---@class NpuBoard.ResetDeviceRsp
local TResetDeviceRsp = {}
TResetDeviceRsp.__index = TResetDeviceRsp
TResetDeviceRsp.group = {}

local function TResetDeviceRsp_from_obj(obj)
    return setmetatable(obj, TResetDeviceRsp)
end

function TResetDeviceRsp.new()
    return TResetDeviceRsp_from_obj({})
end
---@param obj NpuBoard.ResetDeviceRsp
function TResetDeviceRsp:init_from_obj(obj)

end

function TResetDeviceRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetDeviceRsp.group)
end

TResetDeviceRsp.from_obj = TResetDeviceRsp_from_obj

TResetDeviceRsp.proto_property = {}

TResetDeviceRsp.default = {}

TResetDeviceRsp.struct = {}

function TResetDeviceRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetDeviceRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetDeviceRsp.proto_property, errs, need_convert)
    return self
end

function TResetDeviceRsp:unpack(_)
end

NpuBoard.ResetDeviceRsp = TResetDeviceRsp

---@class NpuBoard.ResetDeviceReq
---@field RegionId integer
local TResetDeviceReq = {}
TResetDeviceReq.__index = TResetDeviceReq
TResetDeviceReq.group = {}

local function TResetDeviceReq_from_obj(obj)
    return setmetatable(obj, TResetDeviceReq)
end

function TResetDeviceReq.new(RegionId)
    return TResetDeviceReq_from_obj({RegionId = RegionId})
end
---@param obj NpuBoard.ResetDeviceReq
function TResetDeviceReq:init_from_obj(obj)
    self.RegionId = obj.RegionId
end

function TResetDeviceReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetDeviceReq.group)
end

TResetDeviceReq.from_obj = TResetDeviceReq_from_obj

TResetDeviceReq.proto_property = {'RegionId'}

TResetDeviceReq.default = {0}

TResetDeviceReq.struct = {{name = 'RegionId', is_array = false, struct = nil}}

function TResetDeviceReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RegionId', self.RegionId, 'uint8', false, errs, need_convert)

    TResetDeviceReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetDeviceReq.proto_property, errs, need_convert)
    return self
end

function TResetDeviceReq:unpack(_)
    return self.RegionId
end

NpuBoard.ResetDeviceReq = TResetDeviceReq

---@class NpuBoard.ResetRsp
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new()
    return TResetRsp_from_obj({})
end
---@param obj NpuBoard.ResetRsp
function TResetRsp:init_from_obj(obj)

end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {}

TResetRsp.default = {}

TResetRsp.struct = {}

function TResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetRsp:unpack(_)
end

NpuBoard.ResetRsp = TResetRsp

---@class NpuBoard.ResetReq
---@field Slot integer
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new(Slot)
    return TResetReq_from_obj({Slot = Slot})
end
---@param obj NpuBoard.ResetReq
function TResetReq:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {'Slot'}

TResetReq.default = {0}

TResetReq.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint32', false, errs, need_convert)

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs, need_convert)
    return self
end

function TResetReq:unpack(_)
    return self.Slot
end

NpuBoard.ResetReq = TResetReq

NpuBoard.interface = mdb.register_interface('bmc.kepler.Systems.Board.NpuBoard', {
    PowerWatts = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    PowerCapWatts = {'q', {'EMIT_CHANGE'}, true, nil, false},
    MaxPowerCapWatts = {'q', nil, true, nil, false},
    MinPowerCapWatts = {'q', nil, true, nil, false},
    Model = {'s', nil, true, nil, false},
    ComputeCapability = {'s', nil, true, nil, false},
    VRDUpgradeState = {'y', nil, true, 0, false}
}, {Reset = {'a{ss}u', '', TResetReq, TResetRsp}, ResetDevice = {'a{ss}y', '', TResetDeviceReq, TResetDeviceRsp}}, {})

return NpuBoard
