-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FirmwareInfo = {}

---@class FirmwareInfo.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj FirmwareInfo.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

FirmwareInfo.Object = TObject

---@class FirmwareInfo.EstimatedDuration
---@field EstimatedDuration integer
local TEstimatedDuration = {}
TEstimatedDuration.__index = TEstimatedDuration
TEstimatedDuration.group = {}

local function TEstimatedDuration_from_obj(obj)
    return setmetatable(obj, TEstimatedDuration)
end

function TEstimatedDuration.new(EstimatedDuration)
    return TEstimatedDuration_from_obj({EstimatedDuration = EstimatedDuration})
end
---@param obj FirmwareInfo.EstimatedDuration
function TEstimatedDuration:init_from_obj(obj)
    self.EstimatedDuration = obj.EstimatedDuration
end

function TEstimatedDuration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEstimatedDuration.group)
end

TEstimatedDuration.from_obj = TEstimatedDuration_from_obj

TEstimatedDuration.proto_property = {'EstimatedDuration'}

TEstimatedDuration.default = {0}

TEstimatedDuration.struct = {{name = 'EstimatedDuration', is_array = false, struct = nil}}

function TEstimatedDuration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EstimatedDuration', self.EstimatedDuration, 'uint32', true, errs, need_convert)

    TEstimatedDuration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEstimatedDuration.proto_property, errs, need_convert)
    return self
end

function TEstimatedDuration:unpack(_)
    return self.EstimatedDuration
end

FirmwareInfo.EstimatedDuration = TEstimatedDuration

---@class FirmwareInfo.MaxPackageSizeMiB
---@field MaxPackageSizeMiB integer
local TMaxPackageSizeMiB = {}
TMaxPackageSizeMiB.__index = TMaxPackageSizeMiB
TMaxPackageSizeMiB.group = {}

local function TMaxPackageSizeMiB_from_obj(obj)
    return setmetatable(obj, TMaxPackageSizeMiB)
end

function TMaxPackageSizeMiB.new(MaxPackageSizeMiB)
    return TMaxPackageSizeMiB_from_obj({MaxPackageSizeMiB = MaxPackageSizeMiB})
end
---@param obj FirmwareInfo.MaxPackageSizeMiB
function TMaxPackageSizeMiB:init_from_obj(obj)
    self.MaxPackageSizeMiB = obj.MaxPackageSizeMiB
end

function TMaxPackageSizeMiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxPackageSizeMiB.group)
end

TMaxPackageSizeMiB.from_obj = TMaxPackageSizeMiB_from_obj

TMaxPackageSizeMiB.proto_property = {'MaxPackageSizeMiB'}

TMaxPackageSizeMiB.default = {0}

TMaxPackageSizeMiB.struct = {{name = 'MaxPackageSizeMiB', is_array = false, struct = nil}}

function TMaxPackageSizeMiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxPackageSizeMiB', self.MaxPackageSizeMiB, 'int32', true, errs, need_convert)

    TMaxPackageSizeMiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxPackageSizeMiB.proto_property, errs, need_convert)
    return self
end

function TMaxPackageSizeMiB:unpack(_)
    return self.MaxPackageSizeMiB
end

FirmwareInfo.MaxPackageSizeMiB = TMaxPackageSizeMiB

---@class FirmwareInfo.Severity
---@field Severity string
local TSeverity = {}
TSeverity.__index = TSeverity
TSeverity.group = {}

local function TSeverity_from_obj(obj)
    return setmetatable(obj, TSeverity)
end

function TSeverity.new(Severity)
    return TSeverity_from_obj({Severity = Severity})
end
---@param obj FirmwareInfo.Severity
function TSeverity:init_from_obj(obj)
    self.Severity = obj.Severity
end

function TSeverity:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSeverity.group)
end

TSeverity.from_obj = TSeverity_from_obj

TSeverity.proto_property = {'Severity'}

TSeverity.default = {''}

TSeverity.struct = {{name = 'Severity', is_array = false, struct = nil}}

function TSeverity:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Severity', self.Severity, 'string', false, errs, need_convert)

    TSeverity:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSeverity.proto_property, errs, need_convert)
    return self
end

function TSeverity:unpack(_)
    return self.Severity
end

FirmwareInfo.Severity = TSeverity

---@class FirmwareInfo.State
---@field State string
local TState = {}
TState.__index = TState
TState.group = {}

local function TState_from_obj(obj)
    return setmetatable(obj, TState)
end

function TState.new(State)
    return TState_from_obj({State = State})
end
---@param obj FirmwareInfo.State
function TState:init_from_obj(obj)
    self.State = obj.State
end

function TState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TState.group)
end

TState.from_obj = TState_from_obj

TState.proto_property = {'State'}

TState.default = {''}

TState.struct = {{name = 'State', is_array = false, struct = nil}}

function TState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'string', false, errs, need_convert)

    TState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TState.proto_property, errs, need_convert)
    return self
end

function TState:unpack(_)
    return self.State
end

FirmwareInfo.State = TState

---@class FirmwareInfo.Parameters
---@field Parameters FirmwareInfo.Object
local TParameters = {}
TParameters.__index = TParameters
TParameters.group = {}

local function TParameters_from_obj(obj)
    return setmetatable(obj, TParameters)
end

function TParameters.new(Parameters)
    return TParameters_from_obj({Parameters = Parameters})
end
---@param obj FirmwareInfo.Parameters
function TParameters:init_from_obj(obj)
    self.Parameters = obj.Parameters
end

function TParameters:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParameters.group)
end

TParameters.from_obj = TParameters_from_obj

TParameters.proto_property = {'Parameters'}

TParameters.default = {FirmwareInfo.Object.default}

TParameters.struct = {{name = 'Parameters', is_array = false, struct = FirmwareInfo.Object.struct}}

function TParameters:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    FirmwareInfo.Object.new(self.Parameters):validate(prefix, errs, need_convert)

    TParameters:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParameters.proto_property, errs, need_convert)
    return self
end

function TParameters:unpack(_)
    return self.Parameters
end

FirmwareInfo.Parameters = TParameters

---@class FirmwareInfo.ActiveMode
---@field ActiveMode string
local TActiveMode = {}
TActiveMode.__index = TActiveMode
TActiveMode.group = {}

local function TActiveMode_from_obj(obj)
    return setmetatable(obj, TActiveMode)
end

function TActiveMode.new(ActiveMode)
    return TActiveMode_from_obj({ActiveMode = ActiveMode})
end
---@param obj FirmwareInfo.ActiveMode
function TActiveMode:init_from_obj(obj)
    self.ActiveMode = obj.ActiveMode
end

function TActiveMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActiveMode.group)
end

TActiveMode.from_obj = TActiveMode_from_obj

TActiveMode.proto_property = {'ActiveMode'}

TActiveMode.default = {''}

TActiveMode.struct = {{name = 'ActiveMode', is_array = false, struct = nil}}

function TActiveMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveMode', self.ActiveMode, 'string', false, errs, need_convert)

    TActiveMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActiveMode.proto_property, errs, need_convert)
    return self
end

function TActiveMode:unpack(_)
    return self.ActiveMode
end

FirmwareInfo.ActiveMode = TActiveMode

---@class FirmwareInfo.RollbackStatus
---@field RollbackStatus string
local TRollbackStatus = {}
TRollbackStatus.__index = TRollbackStatus
TRollbackStatus.group = {}

local function TRollbackStatus_from_obj(obj)
    return setmetatable(obj, TRollbackStatus)
end

function TRollbackStatus.new(RollbackStatus)
    return TRollbackStatus_from_obj({RollbackStatus = RollbackStatus})
end
---@param obj FirmwareInfo.RollbackStatus
function TRollbackStatus:init_from_obj(obj)
    self.RollbackStatus = obj.RollbackStatus
end

function TRollbackStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRollbackStatus.group)
end

TRollbackStatus.from_obj = TRollbackStatus_from_obj

TRollbackStatus.proto_property = {'RollbackStatus'}

TRollbackStatus.default = {''}

TRollbackStatus.struct = {{name = 'RollbackStatus', is_array = false, struct = nil}}

function TRollbackStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RollbackStatus', self.RollbackStatus, 'string', false, errs, need_convert)

    TRollbackStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRollbackStatus.proto_property, errs, need_convert)
    return self
end

function TRollbackStatus:unpack(_)
    return self.RollbackStatus
end

FirmwareInfo.RollbackStatus = TRollbackStatus

---@class FirmwareInfo.Location
---@field Location string
local TLocation = {}
TLocation.__index = TLocation
TLocation.group = {}

local function TLocation_from_obj(obj)
    return setmetatable(obj, TLocation)
end

function TLocation.new(Location)
    return TLocation_from_obj({Location = Location})
end
---@param obj FirmwareInfo.Location
function TLocation:init_from_obj(obj)
    self.Location = obj.Location
end

function TLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocation.group)
end

TLocation.from_obj = TLocation_from_obj

TLocation.proto_property = {'Location'}

TLocation.default = {''}

TLocation.struct = {{name = 'Location', is_array = false, struct = nil}}

function TLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Location', self.Location, 'string', true, errs, need_convert)

    TLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocation.proto_property, errs, need_convert)
    return self
end

function TLocation:unpack(_)
    return self.Location
end

FirmwareInfo.Location = TLocation

---@class FirmwareInfo.Updateable
---@field Updateable boolean
local TUpdateable = {}
TUpdateable.__index = TUpdateable
TUpdateable.group = {}

local function TUpdateable_from_obj(obj)
    return setmetatable(obj, TUpdateable)
end

function TUpdateable.new(Updateable)
    return TUpdateable_from_obj({Updateable = Updateable})
end
---@param obj FirmwareInfo.Updateable
function TUpdateable:init_from_obj(obj)
    self.Updateable = obj.Updateable
end

function TUpdateable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateable.group)
end

TUpdateable.from_obj = TUpdateable_from_obj

TUpdateable.proto_property = {'Updateable'}

TUpdateable.default = {false}

TUpdateable.struct = {{name = 'Updateable', is_array = false, struct = nil}}

function TUpdateable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Updateable', self.Updateable, 'bool', true, errs, need_convert)

    TUpdateable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateable.proto_property, errs, need_convert)
    return self
end

function TUpdateable:unpack(_)
    return self.Updateable
end

FirmwareInfo.Updateable = TUpdateable

---@class FirmwareInfo.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj FirmwareInfo.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

FirmwareInfo.Manufacturer = TManufacturer

---@class FirmwareInfo.SoftwareId
---@field SoftwareId string
local TSoftwareId = {}
TSoftwareId.__index = TSoftwareId
TSoftwareId.group = {}

local function TSoftwareId_from_obj(obj)
    return setmetatable(obj, TSoftwareId)
end

function TSoftwareId.new(SoftwareId)
    return TSoftwareId_from_obj({SoftwareId = SoftwareId})
end
---@param obj FirmwareInfo.SoftwareId
function TSoftwareId:init_from_obj(obj)
    self.SoftwareId = obj.SoftwareId
end

function TSoftwareId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSoftwareId.group)
end

TSoftwareId.from_obj = TSoftwareId_from_obj

TSoftwareId.proto_property = {'SoftwareId'}

TSoftwareId.default = {''}

TSoftwareId.struct = {{name = 'SoftwareId', is_array = false, struct = nil}}

function TSoftwareId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SoftwareId', self.SoftwareId, 'string', true, errs, need_convert)

    TSoftwareId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSoftwareId.proto_property, errs, need_convert)
    return self
end

function TSoftwareId:unpack(_)
    return self.SoftwareId
end

FirmwareInfo.SoftwareId = TSoftwareId

---@class FirmwareInfo.LowestSupportedVersion
---@field LowestSupportedVersion string
local TLowestSupportedVersion = {}
TLowestSupportedVersion.__index = TLowestSupportedVersion
TLowestSupportedVersion.group = {}

local function TLowestSupportedVersion_from_obj(obj)
    return setmetatable(obj, TLowestSupportedVersion)
end

function TLowestSupportedVersion.new(LowestSupportedVersion)
    return TLowestSupportedVersion_from_obj({LowestSupportedVersion = LowestSupportedVersion})
end
---@param obj FirmwareInfo.LowestSupportedVersion
function TLowestSupportedVersion:init_from_obj(obj)
    self.LowestSupportedVersion = obj.LowestSupportedVersion
end

function TLowestSupportedVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowestSupportedVersion.group)
end

TLowestSupportedVersion.from_obj = TLowestSupportedVersion_from_obj

TLowestSupportedVersion.proto_property = {'LowestSupportedVersion'}

TLowestSupportedVersion.default = {''}

TLowestSupportedVersion.struct = {{name = 'LowestSupportedVersion', is_array = false, struct = nil}}

function TLowestSupportedVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowestSupportedVersion', self.LowestSupportedVersion, 'string', true, errs,
        need_convert)

    TLowestSupportedVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowestSupportedVersion.proto_property, errs, need_convert)
    return self
end

function TLowestSupportedVersion:unpack(_)
    return self.LowestSupportedVersion
end

FirmwareInfo.LowestSupportedVersion = TLowestSupportedVersion

---@class FirmwareInfo.ReleaseDate
---@field ReleaseDate string
local TReleaseDate = {}
TReleaseDate.__index = TReleaseDate
TReleaseDate.group = {}

local function TReleaseDate_from_obj(obj)
    return setmetatable(obj, TReleaseDate)
end

function TReleaseDate.new(ReleaseDate)
    return TReleaseDate_from_obj({ReleaseDate = ReleaseDate})
end
---@param obj FirmwareInfo.ReleaseDate
function TReleaseDate:init_from_obj(obj)
    self.ReleaseDate = obj.ReleaseDate
end

function TReleaseDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReleaseDate.group)
end

TReleaseDate.from_obj = TReleaseDate_from_obj

TReleaseDate.proto_property = {'ReleaseDate'}

TReleaseDate.default = {''}

TReleaseDate.struct = {{name = 'ReleaseDate', is_array = false, struct = nil}}

function TReleaseDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReleaseDate', self.ReleaseDate, 'string', false, errs, need_convert)

    TReleaseDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReleaseDate.proto_property, errs, need_convert)
    return self
end

function TReleaseDate:unpack(_)
    return self.ReleaseDate
end

FirmwareInfo.ReleaseDate = TReleaseDate

---@class FirmwareInfo.BuildNum
---@field BuildNum string
local TBuildNum = {}
TBuildNum.__index = TBuildNum
TBuildNum.group = {}

local function TBuildNum_from_obj(obj)
    return setmetatable(obj, TBuildNum)
end

function TBuildNum.new(BuildNum)
    return TBuildNum_from_obj({BuildNum = BuildNum})
end
---@param obj FirmwareInfo.BuildNum
function TBuildNum:init_from_obj(obj)
    self.BuildNum = obj.BuildNum
end

function TBuildNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBuildNum.group)
end

TBuildNum.from_obj = TBuildNum_from_obj

TBuildNum.proto_property = {'BuildNum'}

TBuildNum.default = {''}

TBuildNum.struct = {{name = 'BuildNum', is_array = false, struct = nil}}

function TBuildNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BuildNum', self.BuildNum, 'string', true, errs, need_convert)

    TBuildNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBuildNum.proto_property, errs, need_convert)
    return self
end

function TBuildNum:unpack(_)
    return self.BuildNum
end

FirmwareInfo.BuildNum = TBuildNum

---@class FirmwareInfo.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj FirmwareInfo.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

FirmwareInfo.Version = TVersion

---@class FirmwareInfo.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj FirmwareInfo.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

FirmwareInfo.Name = TName

---@class FirmwareInfo.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj FirmwareInfo.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'string', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

FirmwareInfo.Id = TId

FirmwareInfo.interface = mdb.register_interface('bmc.kepler.UpdateService.FirmwareInfo', {
    Id = {'s', {'CONST'}, true, nil, false},
    Name = {'s', {'CONST'}, true, nil, false},
    Version = {'s', nil, false, nil, false},
    BuildNum = {'s', {}, true, nil, false},
    ReleaseDate = {'s', nil, false, nil, false},
    LowestSupportedVersion = {'s', {}, true, nil, false},
    SoftwareId = {'s', nil, true, nil, false},
    Manufacturer = {'s', nil, true, nil, false},
    Updateable = {'b', nil, true, nil, false},
    Location = {'s', nil, true, nil, false},
    RollbackStatus = {'s', {}, false, nil, false},
    ActiveMode = {'s', nil, false, nil, false},
    Parameters = {'a{ss}', nil, false, nil, false},
    State = {'s', nil, false, nil, false},
    Severity = {'s', nil, false, nil, false},
    MaxPackageSizeMiB = {'i', nil, true, nil, false},
    EstimatedDuration = {'u', {}, true, nil, false}
}, {}, {})

return FirmwareInfo
