-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Fault = {}

---@class Fault.HeartBeatLoss
---@field HeartBeatLoss integer
local THeartBeatLoss = {}
THeartBeatLoss.__index = THeartBeatLoss
THeartBeatLoss.group = {}

local function THeartBeatLoss_from_obj(obj)
    return setmetatable(obj, THeartBeatLoss)
end

function THeartBeatLoss.new(HeartBeatLoss)
    return THeartBeatLoss_from_obj({HeartBeatLoss = HeartBeatLoss})
end
---@param obj Fault.HeartBeatLoss
function THeartBeatLoss:init_from_obj(obj)
    self.HeartBeatLoss = obj.HeartBeatLoss
end

function THeartBeatLoss:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THeartBeatLoss.group)
end

THeartBeatLoss.from_obj = THeartBeatLoss_from_obj

THeartBeatLoss.proto_property = {'HeartBeatLoss'}

THeartBeatLoss.default = {0}

THeartBeatLoss.struct = {{name = 'HeartBeatLoss', is_array = false, struct = nil}}

function THeartBeatLoss:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HeartBeatLoss', self.HeartBeatLoss, 'uint8', true, errs, need_convert)

    THeartBeatLoss:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THeartBeatLoss.proto_property, errs, need_convert)
    return self
end

function THeartBeatLoss:unpack(_)
    return self.HeartBeatLoss
end

Fault.HeartBeatLoss = THeartBeatLoss

Fault.interface = mdb.register_interface('bmc.kepler.Systems.DPUCard.Fault',
    {HeartBeatLoss = {'y', nil, true, nil, false}}, {}, {})

return Fault
