-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DPUCardProcessor = {}

---@class DPUCardProcessor.TotalCores
---@field TotalCores integer
local TTotalCores = {}
TTotalCores.__index = TTotalCores
TTotalCores.group = {}

local function TTotalCores_from_obj(obj)
    return setmetatable(obj, TTotalCores)
end

function TTotalCores.new(TotalCores)
    return TTotalCores_from_obj({TotalCores = TotalCores})
end
---@param obj DPUCardProcessor.TotalCores
function TTotalCores:init_from_obj(obj)
    self.TotalCores = obj.TotalCores
end

function TTotalCores:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalCores.group)
end

TTotalCores.from_obj = TTotalCores_from_obj

TTotalCores.proto_property = {'TotalCores'}

TTotalCores.default = {0}

TTotalCores.struct = {{name = 'TotalCores', is_array = false, struct = nil}}

function TTotalCores:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalCores', self.TotalCores, 'uint8', true, errs, need_convert)

    TTotalCores:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalCores.proto_property, errs, need_convert)
    return self
end

function TTotalCores:unpack(_)
    return self.TotalCores
end

DPUCardProcessor.TotalCores = TTotalCores

---@class DPUCardProcessor.Architecture
---@field Architecture string
local TArchitecture = {}
TArchitecture.__index = TArchitecture
TArchitecture.group = {}

local function TArchitecture_from_obj(obj)
    return setmetatable(obj, TArchitecture)
end

function TArchitecture.new(Architecture)
    return TArchitecture_from_obj({Architecture = Architecture})
end
---@param obj DPUCardProcessor.Architecture
function TArchitecture:init_from_obj(obj)
    self.Architecture = obj.Architecture
end

function TArchitecture:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TArchitecture.group)
end

TArchitecture.from_obj = TArchitecture_from_obj

TArchitecture.proto_property = {'Architecture'}

TArchitecture.default = {''}

TArchitecture.struct = {{name = 'Architecture', is_array = false, struct = nil}}

function TArchitecture:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Architecture', self.Architecture, 'string', true, errs, need_convert)

    TArchitecture:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TArchitecture.proto_property, errs, need_convert)
    return self
end

function TArchitecture:unpack(_)
    return self.Architecture
end

DPUCardProcessor.Architecture = TArchitecture

DPUCardProcessor.interface = mdb.register_interface('bmc.kepler.Systems.DPUCard.Processor', {
    Architecture = {'s', {}, true, nil, false},
    TotalCores = {'y', {}, true, nil, false}
}, {}, {})

return DPUCardProcessor
