-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local DPUCard = {}

---@class DPUCard.SystemBootStatus: Enum
local ESystemBootStatus = create_enum_type('SystemBootStatus')
ESystemBootStatus.default = ESystemBootStatus.new(2147483647)
ESystemBootStatus.struct = nil
ESystemBootStatus.OSBootNotStarted = ESystemBootStatus.new(0)
ESystemBootStatus.OSBootStarting = ESystemBootStatus.new(1)
ESystemBootStatus.OSBootFailed = ESystemBootStatus.new(2)
ESystemBootStatus.OSBootCompleted = ESystemBootStatus.new(3)
ESystemBootStatus.OSBootTimeout = ESystemBootStatus.new(4)
ESystemBootStatus.NoBootableDevice = ESystemBootStatus.new(5)

DPUCard.SystemBootStatus = ESystemBootStatus

---@class DPUCard.MCUVersion
---@field MCUVersion string
local TMCUVersion = {}
TMCUVersion.__index = TMCUVersion
TMCUVersion.group = {}

local function TMCUVersion_from_obj(obj)
    return setmetatable(obj, TMCUVersion)
end

function TMCUVersion.new(MCUVersion)
    return TMCUVersion_from_obj({MCUVersion = MCUVersion})
end
---@param obj DPUCard.MCUVersion
function TMCUVersion:init_from_obj(obj)
    self.MCUVersion = obj.MCUVersion
end

function TMCUVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMCUVersion.group)
end

TMCUVersion.from_obj = TMCUVersion_from_obj

TMCUVersion.proto_property = {'MCUVersion'}

TMCUVersion.default = {''}

TMCUVersion.struct = {{name = 'MCUVersion', is_array = false, struct = nil}}

function TMCUVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MCUVersion', self.MCUVersion, 'string', true, errs, need_convert)

    TMCUVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMCUVersion.proto_property, errs, need_convert)
    return self
end

function TMCUVersion:unpack(_)
    return self.MCUVersion
end

DPUCard.MCUVersion = TMCUVersion

---@class DPUCard.NetworkAdapterPresence
---@field NetworkAdapterPresence integer
local TNetworkAdapterPresence = {}
TNetworkAdapterPresence.__index = TNetworkAdapterPresence
TNetworkAdapterPresence.group = {}

local function TNetworkAdapterPresence_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterPresence)
end

function TNetworkAdapterPresence.new(NetworkAdapterPresence)
    return TNetworkAdapterPresence_from_obj({NetworkAdapterPresence = NetworkAdapterPresence})
end
---@param obj DPUCard.NetworkAdapterPresence
function TNetworkAdapterPresence:init_from_obj(obj)
    self.NetworkAdapterPresence = obj.NetworkAdapterPresence
end

function TNetworkAdapterPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterPresence.group)
end

TNetworkAdapterPresence.from_obj = TNetworkAdapterPresence_from_obj

TNetworkAdapterPresence.proto_property = {'NetworkAdapterPresence'}

TNetworkAdapterPresence.default = {0}

TNetworkAdapterPresence.struct = {{name = 'NetworkAdapterPresence', is_array = false, struct = nil}}

function TNetworkAdapterPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkAdapterPresence', self.NetworkAdapterPresence, 'uint8', true, errs, need_convert)

    TNetworkAdapterPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterPresence.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterPresence:unpack(_)
    return self.NetworkAdapterPresence
end

DPUCard.NetworkAdapterPresence = TNetworkAdapterPresence

---@class DPUCard.M2SlotPresence
---@field M2SlotPresence integer
local TM2SlotPresence = {}
TM2SlotPresence.__index = TM2SlotPresence
TM2SlotPresence.group = {}

local function TM2SlotPresence_from_obj(obj)
    return setmetatable(obj, TM2SlotPresence)
end

function TM2SlotPresence.new(M2SlotPresence)
    return TM2SlotPresence_from_obj({M2SlotPresence = M2SlotPresence})
end
---@param obj DPUCard.M2SlotPresence
function TM2SlotPresence:init_from_obj(obj)
    self.M2SlotPresence = obj.M2SlotPresence
end

function TM2SlotPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TM2SlotPresence.group)
end

TM2SlotPresence.from_obj = TM2SlotPresence_from_obj

TM2SlotPresence.proto_property = {'M2SlotPresence'}

TM2SlotPresence.default = {0}

TM2SlotPresence.struct = {{name = 'M2SlotPresence', is_array = false, struct = nil}}

function TM2SlotPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'M2SlotPresence', self.M2SlotPresence, 'uint8', true, errs, need_convert)

    TM2SlotPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TM2SlotPresence.proto_property, errs, need_convert)
    return self
end

function TM2SlotPresence:unpack(_)
    return self.M2SlotPresence
end

DPUCard.M2SlotPresence = TM2SlotPresence

---@class DPUCard.StorageIpVlan
---@field StorageIpVlan integer
local TStorageIpVlan = {}
TStorageIpVlan.__index = TStorageIpVlan
TStorageIpVlan.group = {}

local function TStorageIpVlan_from_obj(obj)
    return setmetatable(obj, TStorageIpVlan)
end

function TStorageIpVlan.new(StorageIpVlan)
    return TStorageIpVlan_from_obj({StorageIpVlan = StorageIpVlan})
end
---@param obj DPUCard.StorageIpVlan
function TStorageIpVlan:init_from_obj(obj)
    self.StorageIpVlan = obj.StorageIpVlan
end

function TStorageIpVlan:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStorageIpVlan.group)
end

TStorageIpVlan.from_obj = TStorageIpVlan_from_obj

TStorageIpVlan.proto_property = {'StorageIpVlan'}

TStorageIpVlan.default = {0}

TStorageIpVlan.struct = {{name = 'StorageIpVlan', is_array = false, struct = nil}}

function TStorageIpVlan:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StorageIpVlan', self.StorageIpVlan, 'uint16', true, errs, need_convert)

    TStorageIpVlan:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStorageIpVlan.proto_property, errs, need_convert)
    return self
end

function TStorageIpVlan:unpack(_)
    return self.StorageIpVlan
end

DPUCard.StorageIpVlan = TStorageIpVlan

---@class DPUCard.StorageIpAddr
---@field StorageIpAddr string
local TStorageIpAddr = {}
TStorageIpAddr.__index = TStorageIpAddr
TStorageIpAddr.group = {}

local function TStorageIpAddr_from_obj(obj)
    return setmetatable(obj, TStorageIpAddr)
end

function TStorageIpAddr.new(StorageIpAddr)
    return TStorageIpAddr_from_obj({StorageIpAddr = StorageIpAddr})
end
---@param obj DPUCard.StorageIpAddr
function TStorageIpAddr:init_from_obj(obj)
    self.StorageIpAddr = obj.StorageIpAddr
end

function TStorageIpAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStorageIpAddr.group)
end

TStorageIpAddr.from_obj = TStorageIpAddr_from_obj

TStorageIpAddr.proto_property = {'StorageIpAddr'}

TStorageIpAddr.default = {''}

TStorageIpAddr.struct = {{name = 'StorageIpAddr', is_array = false, struct = nil}}

function TStorageIpAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StorageIpAddr', self.StorageIpAddr, 'string', true, errs, need_convert)

    TStorageIpAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStorageIpAddr.proto_property, errs, need_convert)
    return self
end

function TStorageIpAddr:unpack(_)
    return self.StorageIpAddr
end

DPUCard.StorageIpAddr = TStorageIpAddr

---@class DPUCard.OSSupported
---@field OSSupported boolean
local TOSSupported = {}
TOSSupported.__index = TOSSupported
TOSSupported.group = {}

local function TOSSupported_from_obj(obj)
    return setmetatable(obj, TOSSupported)
end

function TOSSupported.new(OSSupported)
    return TOSSupported_from_obj({OSSupported = OSSupported == nil and true or OSSupported})
end
---@param obj DPUCard.OSSupported
function TOSSupported:init_from_obj(obj)
    self.OSSupported = obj.OSSupported == nil and true or obj.OSSupported
end

function TOSSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOSSupported.group)
end

TOSSupported.from_obj = TOSSupported_from_obj

TOSSupported.proto_property = {'OSSupported'}

TOSSupported.default = {false}

TOSSupported.struct = {{name = 'OSSupported', is_array = false, struct = nil}}

function TOSSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OSSupported', self.OSSupported, 'bool', true, errs, need_convert)

    TOSSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOSSupported.proto_property, errs, need_convert)
    return self
end

function TOSSupported:unpack(_)
    return self.OSSupported
end

DPUCard.OSSupported = TOSSupported

---@class DPUCard.VrdVersion
---@field VrdVersion string
local TVrdVersion = {}
TVrdVersion.__index = TVrdVersion
TVrdVersion.group = {}

local function TVrdVersion_from_obj(obj)
    return setmetatable(obj, TVrdVersion)
end

function TVrdVersion.new(VrdVersion)
    return TVrdVersion_from_obj({VrdVersion = VrdVersion})
end
---@param obj DPUCard.VrdVersion
function TVrdVersion:init_from_obj(obj)
    self.VrdVersion = obj.VrdVersion
end

function TVrdVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVrdVersion.group)
end

TVrdVersion.from_obj = TVrdVersion_from_obj

TVrdVersion.proto_property = {'VrdVersion'}

TVrdVersion.default = {''}

TVrdVersion.struct = {{name = 'VrdVersion', is_array = false, struct = nil}}

function TVrdVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VrdVersion', self.VrdVersion, 'string', true, errs, need_convert)

    TVrdVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVrdVersion.proto_property, errs, need_convert)
    return self
end

function TVrdVersion:unpack(_)
    return self.VrdVersion
end

DPUCard.VrdVersion = TVrdVersion

---@class DPUCard.MPUBusyStatus
---@field MPUBusyStatus integer
local TMPUBusyStatus = {}
TMPUBusyStatus.__index = TMPUBusyStatus
TMPUBusyStatus.group = {}

local function TMPUBusyStatus_from_obj(obj)
    return setmetatable(obj, TMPUBusyStatus)
end

function TMPUBusyStatus.new(MPUBusyStatus)
    return TMPUBusyStatus_from_obj({MPUBusyStatus = MPUBusyStatus})
end
---@param obj DPUCard.MPUBusyStatus
function TMPUBusyStatus:init_from_obj(obj)
    self.MPUBusyStatus = obj.MPUBusyStatus
end

function TMPUBusyStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMPUBusyStatus.group)
end

TMPUBusyStatus.from_obj = TMPUBusyStatus_from_obj

TMPUBusyStatus.proto_property = {'MPUBusyStatus'}

TMPUBusyStatus.default = {0}

TMPUBusyStatus.struct = {{name = 'MPUBusyStatus', is_array = false, struct = nil}}

function TMPUBusyStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MPUBusyStatus', self.MPUBusyStatus, 'uint8', false, errs, need_convert)

    TMPUBusyStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMPUBusyStatus.proto_property, errs, need_convert)
    return self
end

function TMPUBusyStatus:unpack(_)
    return self.MPUBusyStatus
end

DPUCard.MPUBusyStatus = TMPUBusyStatus

---@class DPUCard.PowerState
---@field PowerState string
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState or [=[Off]=]})
end
---@param obj DPUCard.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState or [=[Off]=]
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {''}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'string', true, errs, need_convert)

    if self.PowerState ~= nil then
        validate.Enum(prefix .. 'PowerState', self.PowerState, '', {'On', 'Off'}, errs, need_convert)
    end

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

DPUCard.PowerState = TPowerState

---@class DPUCard.CPLDCount
---@field CPLDCount integer
local TCPLDCount = {}
TCPLDCount.__index = TCPLDCount
TCPLDCount.group = {}

local function TCPLDCount_from_obj(obj)
    return setmetatable(obj, TCPLDCount)
end

function TCPLDCount.new(CPLDCount)
    return TCPLDCount_from_obj({CPLDCount = CPLDCount or 1})
end
---@param obj DPUCard.CPLDCount
function TCPLDCount:init_from_obj(obj)
    self.CPLDCount = obj.CPLDCount or 1
end

function TCPLDCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCPLDCount.group)
end

TCPLDCount.from_obj = TCPLDCount_from_obj

TCPLDCount.proto_property = {'CPLDCount'}

TCPLDCount.default = {0}

TCPLDCount.struct = {{name = 'CPLDCount', is_array = false, struct = nil}}

function TCPLDCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CPLDCount', self.CPLDCount, 'uint8', true, errs, need_convert)

    TCPLDCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCPLDCount.proto_property, errs, need_convert)
    return self
end

function TCPLDCount:unpack(_)
    return self.CPLDCount
end

DPUCard.CPLDCount = TCPLDCount

---@class DPUCard.LogicVersion
---@field LogicVersion string
local TLogicVersion = {}
TLogicVersion.__index = TLogicVersion
TLogicVersion.group = {}

local function TLogicVersion_from_obj(obj)
    return setmetatable(obj, TLogicVersion)
end

function TLogicVersion.new(LogicVersion)
    return TLogicVersion_from_obj({LogicVersion = LogicVersion})
end
---@param obj DPUCard.LogicVersion
function TLogicVersion:init_from_obj(obj)
    self.LogicVersion = obj.LogicVersion
end

function TLogicVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicVersion.group)
end

TLogicVersion.from_obj = TLogicVersion_from_obj

TLogicVersion.proto_property = {'LogicVersion'}

TLogicVersion.default = {''}

TLogicVersion.struct = {{name = 'LogicVersion', is_array = false, struct = nil}}

function TLogicVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicVersion', self.LogicVersion, 'string', true, errs, need_convert)

    TLogicVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicVersion.proto_property, errs, need_convert)
    return self
end

function TLogicVersion:unpack(_)
    return self.LogicVersion
end

DPUCard.LogicVersion = TLogicVersion

---@class DPUCard.UEFILogLevel
---@field UEFILogLevel integer
local TUEFILogLevel = {}
TUEFILogLevel.__index = TUEFILogLevel
TUEFILogLevel.group = {}

local function TUEFILogLevel_from_obj(obj)
    return setmetatable(obj, TUEFILogLevel)
end

function TUEFILogLevel.new(UEFILogLevel)
    return TUEFILogLevel_from_obj({UEFILogLevel = UEFILogLevel})
end
---@param obj DPUCard.UEFILogLevel
function TUEFILogLevel:init_from_obj(obj)
    self.UEFILogLevel = obj.UEFILogLevel
end

function TUEFILogLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUEFILogLevel.group)
end

TUEFILogLevel.from_obj = TUEFILogLevel_from_obj

TUEFILogLevel.proto_property = {'UEFILogLevel'}

TUEFILogLevel.default = {0}

TUEFILogLevel.struct = {{name = 'UEFILogLevel', is_array = false, struct = nil}}

function TUEFILogLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UEFILogLevel', self.UEFILogLevel, 'uint8', false, errs, need_convert)

    if self.UEFILogLevel ~= nil then
        validate.Enum(prefix .. 'UEFILogLevel', self.UEFILogLevel, '', {1, 2}, errs, need_convert)
    end

    TUEFILogLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUEFILogLevel.proto_property, errs, need_convert)
    return self
end

function TUEFILogLevel:unpack(_)
    return self.UEFILogLevel
end

DPUCard.UEFILogLevel = TUEFILogLevel

---@class DPUCard.MRCLogLevel
---@field MRCLogLevel integer
local TMRCLogLevel = {}
TMRCLogLevel.__index = TMRCLogLevel
TMRCLogLevel.group = {}

local function TMRCLogLevel_from_obj(obj)
    return setmetatable(obj, TMRCLogLevel)
end

function TMRCLogLevel.new(MRCLogLevel)
    return TMRCLogLevel_from_obj({MRCLogLevel = MRCLogLevel})
end
---@param obj DPUCard.MRCLogLevel
function TMRCLogLevel:init_from_obj(obj)
    self.MRCLogLevel = obj.MRCLogLevel
end

function TMRCLogLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMRCLogLevel.group)
end

TMRCLogLevel.from_obj = TMRCLogLevel_from_obj

TMRCLogLevel.proto_property = {'MRCLogLevel'}

TMRCLogLevel.default = {0}

TMRCLogLevel.struct = {{name = 'MRCLogLevel', is_array = false, struct = nil}}

function TMRCLogLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MRCLogLevel', self.MRCLogLevel, 'uint8', false, errs, need_convert)

    if self.MRCLogLevel ~= nil then
        validate.Enum(prefix .. 'MRCLogLevel', self.MRCLogLevel, '', {1, 2}, errs, need_convert)
    end

    TMRCLogLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMRCLogLevel.proto_property, errs, need_convert)
    return self
end

function TMRCLogLevel:unpack(_)
    return self.MRCLogLevel
end

DPUCard.MRCLogLevel = TMRCLogLevel

---@class DPUCard.UID
---@field UID string
local TUID = {}
TUID.__index = TUID
TUID.group = {}

local function TUID_from_obj(obj)
    return setmetatable(obj, TUID)
end

function TUID.new(UID)
    return TUID_from_obj({UID = UID})
end
---@param obj DPUCard.UID
function TUID:init_from_obj(obj)
    self.UID = obj.UID
end

function TUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUID.group)
end

TUID.from_obj = TUID_from_obj

TUID.proto_property = {'UID'}

TUID.default = {''}

TUID.struct = {{name = 'UID', is_array = false, struct = nil}}

function TUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', true, errs, need_convert)

    TUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUID.proto_property, errs, need_convert)
    return self
end

function TUID:unpack(_)
    return self.UID
end

DPUCard.UID = TUID

---@class DPUCard.SRVersion
---@field SRVersion string
local TSRVersion = {}
TSRVersion.__index = TSRVersion
TSRVersion.group = {}

local function TSRVersion_from_obj(obj)
    return setmetatable(obj, TSRVersion)
end

function TSRVersion.new(SRVersion)
    return TSRVersion_from_obj({SRVersion = SRVersion})
end
---@param obj DPUCard.SRVersion
function TSRVersion:init_from_obj(obj)
    self.SRVersion = obj.SRVersion
end

function TSRVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSRVersion.group)
end

TSRVersion.from_obj = TSRVersion_from_obj

TSRVersion.proto_property = {'SRVersion'}

TSRVersion.default = {''}

TSRVersion.struct = {{name = 'SRVersion', is_array = false, struct = nil}}

function TSRVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SRVersion', self.SRVersion, 'string', true, errs, need_convert)

    TSRVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSRVersion.proto_property, errs, need_convert)
    return self
end

function TSRVersion:unpack(_)
    return self.SRVersion
end

DPUCard.SRVersion = TSRVersion

---@class DPUCard.Model
---@field Model string
local TModel = {}
TModel.__index = TModel
TModel.group = {}

local function TModel_from_obj(obj)
    return setmetatable(obj, TModel)
end

function TModel.new(Model)
    return TModel_from_obj({Model = Model})
end
---@param obj DPUCard.Model
function TModel:init_from_obj(obj)
    self.Model = obj.Model
end

function TModel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModel.group)
end

TModel.from_obj = TModel_from_obj

TModel.proto_property = {'Model'}

TModel.default = {''}

TModel.struct = {{name = 'Model', is_array = false, struct = nil}}

function TModel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Model', self.Model, 'string', true, errs, need_convert)

    TModel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModel.proto_property, errs, need_convert)
    return self
end

function TModel:unpack(_)
    return self.Model
end

DPUCard.Model = TModel

---@class DPUCard.NetworkAdapterMaxCount
---@field NetworkAdapterMaxCount integer
local TNetworkAdapterMaxCount = {}
TNetworkAdapterMaxCount.__index = TNetworkAdapterMaxCount
TNetworkAdapterMaxCount.group = {}

local function TNetworkAdapterMaxCount_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterMaxCount)
end

function TNetworkAdapterMaxCount.new(NetworkAdapterMaxCount)
    return TNetworkAdapterMaxCount_from_obj({NetworkAdapterMaxCount = NetworkAdapterMaxCount})
end
---@param obj DPUCard.NetworkAdapterMaxCount
function TNetworkAdapterMaxCount:init_from_obj(obj)
    self.NetworkAdapterMaxCount = obj.NetworkAdapterMaxCount
end

function TNetworkAdapterMaxCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterMaxCount.group)
end

TNetworkAdapterMaxCount.from_obj = TNetworkAdapterMaxCount_from_obj

TNetworkAdapterMaxCount.proto_property = {'NetworkAdapterMaxCount'}

TNetworkAdapterMaxCount.default = {0}

TNetworkAdapterMaxCount.struct = {{name = 'NetworkAdapterMaxCount', is_array = false, struct = nil}}

function TNetworkAdapterMaxCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkAdapterMaxCount', self.NetworkAdapterMaxCount, 'uint8', true, errs, need_convert)

    TNetworkAdapterMaxCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterMaxCount.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterMaxCount:unpack(_)
    return self.NetworkAdapterMaxCount
end

DPUCard.NetworkAdapterMaxCount = TNetworkAdapterMaxCount

---@class DPUCard.M2SlotMaxCount
---@field M2SlotMaxCount integer
local TM2SlotMaxCount = {}
TM2SlotMaxCount.__index = TM2SlotMaxCount
TM2SlotMaxCount.group = {}

local function TM2SlotMaxCount_from_obj(obj)
    return setmetatable(obj, TM2SlotMaxCount)
end

function TM2SlotMaxCount.new(M2SlotMaxCount)
    return TM2SlotMaxCount_from_obj({M2SlotMaxCount = M2SlotMaxCount})
end
---@param obj DPUCard.M2SlotMaxCount
function TM2SlotMaxCount:init_from_obj(obj)
    self.M2SlotMaxCount = obj.M2SlotMaxCount
end

function TM2SlotMaxCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TM2SlotMaxCount.group)
end

TM2SlotMaxCount.from_obj = TM2SlotMaxCount_from_obj

TM2SlotMaxCount.proto_property = {'M2SlotMaxCount'}

TM2SlotMaxCount.default = {0}

TM2SlotMaxCount.struct = {{name = 'M2SlotMaxCount', is_array = false, struct = nil}}

function TM2SlotMaxCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'M2SlotMaxCount', self.M2SlotMaxCount, 'uint8', true, errs, need_convert)

    TM2SlotMaxCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TM2SlotMaxCount.proto_property, errs, need_convert)
    return self
end

function TM2SlotMaxCount:unpack(_)
    return self.M2SlotMaxCount
end

DPUCard.M2SlotMaxCount = TM2SlotMaxCount

---@class DPUCard.BootSourceOverrideEnabled
---@field BootSourceOverrideEnabled integer
local TBootSourceOverrideEnabled = {}
TBootSourceOverrideEnabled.__index = TBootSourceOverrideEnabled
TBootSourceOverrideEnabled.group = {}

local function TBootSourceOverrideEnabled_from_obj(obj)
    return setmetatable(obj, TBootSourceOverrideEnabled)
end

function TBootSourceOverrideEnabled.new(BootSourceOverrideEnabled)
    return TBootSourceOverrideEnabled_from_obj({BootSourceOverrideEnabled = BootSourceOverrideEnabled or 255})
end
---@param obj DPUCard.BootSourceOverrideEnabled
function TBootSourceOverrideEnabled:init_from_obj(obj)
    self.BootSourceOverrideEnabled = obj.BootSourceOverrideEnabled or 255
end

function TBootSourceOverrideEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootSourceOverrideEnabled.group)
end

TBootSourceOverrideEnabled.from_obj = TBootSourceOverrideEnabled_from_obj

TBootSourceOverrideEnabled.proto_property = {'BootSourceOverrideEnabled'}

TBootSourceOverrideEnabled.default = {0}

TBootSourceOverrideEnabled.struct = {{name = 'BootSourceOverrideEnabled', is_array = false, struct = nil}}

function TBootSourceOverrideEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootSourceOverrideEnabled', self.BootSourceOverrideEnabled, 'uint8', true, errs,
        need_convert)

    TBootSourceOverrideEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootSourceOverrideEnabled.proto_property, errs, need_convert)
    return self
end

function TBootSourceOverrideEnabled:unpack(_)
    return self.BootSourceOverrideEnabled
end

DPUCard.BootSourceOverrideEnabled = TBootSourceOverrideEnabled

---@class DPUCard.UUID
---@field UUID string
local TUUID = {}
TUUID.__index = TUUID
TUUID.group = {}

local function TUUID_from_obj(obj)
    return setmetatable(obj, TUUID)
end

function TUUID.new(UUID)
    return TUUID_from_obj({UUID = UUID})
end
---@param obj DPUCard.UUID
function TUUID:init_from_obj(obj)
    self.UUID = obj.UUID
end

function TUUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUUID.group)
end

TUUID.from_obj = TUUID_from_obj

TUUID.proto_property = {'UUID'}

TUUID.default = {''}

TUUID.struct = {{name = 'UUID', is_array = false, struct = nil}}

function TUUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UUID', self.UUID, 'string', true, errs, need_convert)

    TUUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUUID.proto_property, errs, need_convert)
    return self
end

function TUUID:unpack(_)
    return self.UUID
end

DPUCard.UUID = TUUID

---@class DPUCard.PxeOption
---@field PxeOption string
local TPxeOption = {}
TPxeOption.__index = TPxeOption
TPxeOption.group = {}

local function TPxeOption_from_obj(obj)
    return setmetatable(obj, TPxeOption)
end

function TPxeOption.new(PxeOption)
    return TPxeOption_from_obj({PxeOption = PxeOption or [=[UefiIpv4]=]})
end
---@param obj DPUCard.PxeOption
function TPxeOption:init_from_obj(obj)
    self.PxeOption = obj.PxeOption or [=[UefiIpv4]=]
end

function TPxeOption:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPxeOption.group)
end

TPxeOption.from_obj = TPxeOption_from_obj

TPxeOption.proto_property = {'PxeOption'}

TPxeOption.default = {''}

TPxeOption.struct = {{name = 'PxeOption', is_array = false, struct = nil}}

function TPxeOption:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PxeOption', self.PxeOption, 'string', false, errs, need_convert)

    TPxeOption:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPxeOption.proto_property, errs, need_convert)
    return self
end

function TPxeOption:unpack(_)
    return self.PxeOption
end

DPUCard.PxeOption = TPxeOption

---@class DPUCard.BootSourceOverrideMode
---@field BootSourceOverrideMode integer
local TBootSourceOverrideMode = {}
TBootSourceOverrideMode.__index = TBootSourceOverrideMode
TBootSourceOverrideMode.group = {}

local function TBootSourceOverrideMode_from_obj(obj)
    return setmetatable(obj, TBootSourceOverrideMode)
end

function TBootSourceOverrideMode.new(BootSourceOverrideMode)
    return TBootSourceOverrideMode_from_obj({BootSourceOverrideMode = BootSourceOverrideMode or 255})
end
---@param obj DPUCard.BootSourceOverrideMode
function TBootSourceOverrideMode:init_from_obj(obj)
    self.BootSourceOverrideMode = obj.BootSourceOverrideMode or 255
end

function TBootSourceOverrideMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootSourceOverrideMode.group)
end

TBootSourceOverrideMode.from_obj = TBootSourceOverrideMode_from_obj

TBootSourceOverrideMode.proto_property = {'BootSourceOverrideMode'}

TBootSourceOverrideMode.default = {0}

TBootSourceOverrideMode.struct = {{name = 'BootSourceOverrideMode', is_array = false, struct = nil}}

function TBootSourceOverrideMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootSourceOverrideMode', self.BootSourceOverrideMode, 'uint8', true, errs, need_convert)

    TBootSourceOverrideMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootSourceOverrideMode.proto_property, errs, need_convert)
    return self
end

function TBootSourceOverrideMode:unpack(_)
    return self.BootSourceOverrideMode
end

DPUCard.BootSourceOverrideMode = TBootSourceOverrideMode

---@class DPUCard.GetLLDPStatusRsp
---@field Status integer
local TGetLLDPStatusRsp = {}
TGetLLDPStatusRsp.__index = TGetLLDPStatusRsp
TGetLLDPStatusRsp.group = {}

local function TGetLLDPStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetLLDPStatusRsp)
end

function TGetLLDPStatusRsp.new(Status)
    return TGetLLDPStatusRsp_from_obj({Status = Status})
end
---@param obj DPUCard.GetLLDPStatusRsp
function TGetLLDPStatusRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TGetLLDPStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLLDPStatusRsp.group)
end

TGetLLDPStatusRsp.from_obj = TGetLLDPStatusRsp_from_obj

TGetLLDPStatusRsp.proto_property = {'Status'}

TGetLLDPStatusRsp.default = {0}

TGetLLDPStatusRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TGetLLDPStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TGetLLDPStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLLDPStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetLLDPStatusRsp:unpack(_)
    return self.Status
end

DPUCard.GetLLDPStatusRsp = TGetLLDPStatusRsp

---@class DPUCard.GetLLDPStatusReq
---@field PortId integer
local TGetLLDPStatusReq = {}
TGetLLDPStatusReq.__index = TGetLLDPStatusReq
TGetLLDPStatusReq.group = {}

local function TGetLLDPStatusReq_from_obj(obj)
    return setmetatable(obj, TGetLLDPStatusReq)
end

function TGetLLDPStatusReq.new(PortId)
    return TGetLLDPStatusReq_from_obj({PortId = PortId})
end
---@param obj DPUCard.GetLLDPStatusReq
function TGetLLDPStatusReq:init_from_obj(obj)
    self.PortId = obj.PortId
end

function TGetLLDPStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLLDPStatusReq.group)
end

TGetLLDPStatusReq.from_obj = TGetLLDPStatusReq_from_obj

TGetLLDPStatusReq.proto_property = {'PortId'}

TGetLLDPStatusReq.default = {0}

TGetLLDPStatusReq.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TGetLLDPStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', false, errs, need_convert)

    TGetLLDPStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLLDPStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetLLDPStatusReq:unpack(_)
    return self.PortId
end

DPUCard.GetLLDPStatusReq = TGetLLDPStatusReq

---@class DPUCard.SetLLDPStatusRsp
local TSetLLDPStatusRsp = {}
TSetLLDPStatusRsp.__index = TSetLLDPStatusRsp
TSetLLDPStatusRsp.group = {}

local function TSetLLDPStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetLLDPStatusRsp)
end

function TSetLLDPStatusRsp.new()
    return TSetLLDPStatusRsp_from_obj({})
end
---@param obj DPUCard.SetLLDPStatusRsp
function TSetLLDPStatusRsp:init_from_obj(obj)

end

function TSetLLDPStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLLDPStatusRsp.group)
end

TSetLLDPStatusRsp.from_obj = TSetLLDPStatusRsp_from_obj

TSetLLDPStatusRsp.proto_property = {}

TSetLLDPStatusRsp.default = {}

TSetLLDPStatusRsp.struct = {}

function TSetLLDPStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetLLDPStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLLDPStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetLLDPStatusRsp:unpack(_)
end

DPUCard.SetLLDPStatusRsp = TSetLLDPStatusRsp

---@class DPUCard.SetLLDPStatusReq
---@field PortId integer
---@field Status integer
local TSetLLDPStatusReq = {}
TSetLLDPStatusReq.__index = TSetLLDPStatusReq
TSetLLDPStatusReq.group = {}

local function TSetLLDPStatusReq_from_obj(obj)
    return setmetatable(obj, TSetLLDPStatusReq)
end

function TSetLLDPStatusReq.new(PortId, Status)
    return TSetLLDPStatusReq_from_obj({PortId = PortId, Status = Status})
end
---@param obj DPUCard.SetLLDPStatusReq
function TSetLLDPStatusReq:init_from_obj(obj)
    self.PortId = obj.PortId
    self.Status = obj.Status
end

function TSetLLDPStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLLDPStatusReq.group)
end

TSetLLDPStatusReq.from_obj = TSetLLDPStatusReq_from_obj

TSetLLDPStatusReq.proto_property = {'PortId', 'Status'}

TSetLLDPStatusReq.default = {0, 0}

TSetLLDPStatusReq.struct = {
    {name = 'PortId', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil}
}

function TSetLLDPStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetLLDPStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLLDPStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetLLDPStatusReq:unpack(_)
    return self.PortId, self.Status
end

DPUCard.SetLLDPStatusReq = TSetLLDPStatusReq

---@class DPUCard.ImportPublicKeyRsp
local TImportPublicKeyRsp = {}
TImportPublicKeyRsp.__index = TImportPublicKeyRsp
TImportPublicKeyRsp.group = {}

local function TImportPublicKeyRsp_from_obj(obj)
    return setmetatable(obj, TImportPublicKeyRsp)
end

function TImportPublicKeyRsp.new()
    return TImportPublicKeyRsp_from_obj({})
end
---@param obj DPUCard.ImportPublicKeyRsp
function TImportPublicKeyRsp:init_from_obj(obj)

end

function TImportPublicKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportPublicKeyRsp.group)
end

TImportPublicKeyRsp.from_obj = TImportPublicKeyRsp_from_obj

TImportPublicKeyRsp.proto_property = {}

TImportPublicKeyRsp.default = {}

TImportPublicKeyRsp.struct = {}

function TImportPublicKeyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportPublicKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportPublicKeyRsp.proto_property, errs, need_convert)
    return self
end

function TImportPublicKeyRsp:unpack(_)
end

DPUCard.ImportPublicKeyRsp = TImportPublicKeyRsp

---@class DPUCard.ImportPublicKeyReq
---@field Type string
---@field Content string
local TImportPublicKeyReq = {}
TImportPublicKeyReq.__index = TImportPublicKeyReq
TImportPublicKeyReq.group = {}

local function TImportPublicKeyReq_from_obj(obj)
    return setmetatable(obj, TImportPublicKeyReq)
end

function TImportPublicKeyReq.new(Type, Content)
    return TImportPublicKeyReq_from_obj({Type = Type, Content = Content})
end
---@param obj DPUCard.ImportPublicKeyReq
function TImportPublicKeyReq:init_from_obj(obj)
    self.Type = obj.Type
    self.Content = obj.Content
end

function TImportPublicKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportPublicKeyReq.group)
end

TImportPublicKeyReq.from_obj = TImportPublicKeyReq_from_obj

TImportPublicKeyReq.proto_property = {'Type', 'Content'}

TImportPublicKeyReq.default = {'', ''}

TImportPublicKeyReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'Content', is_array = false, struct = nil}
}

function TImportPublicKeyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Content', self.Content, 'string', false, errs, need_convert)

    if self.Type ~= nil then
        validate.Enum(prefix .. 'Type', self.Type, '', {'URI', 'text'}, errs, need_convert)
    end

    TImportPublicKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportPublicKeyReq.proto_property, errs, need_convert)
    return self
end

function TImportPublicKeyReq:unpack(_)
    return self.Type, self.Content
end

DPUCard.ImportPublicKeyReq = TImportPublicKeyReq

---@class DPUCard.SetBootOptionRsp
local TSetBootOptionRsp = {}
TSetBootOptionRsp.__index = TSetBootOptionRsp
TSetBootOptionRsp.group = {}

local function TSetBootOptionRsp_from_obj(obj)
    return setmetatable(obj, TSetBootOptionRsp)
end

function TSetBootOptionRsp.new()
    return TSetBootOptionRsp_from_obj({})
end
---@param obj DPUCard.SetBootOptionRsp
function TSetBootOptionRsp:init_from_obj(obj)

end

function TSetBootOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionRsp.group)
end

TSetBootOptionRsp.from_obj = TSetBootOptionRsp_from_obj

TSetBootOptionRsp.proto_property = {}

TSetBootOptionRsp.default = {}

TSetBootOptionRsp.struct = {}

function TSetBootOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBootOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionRsp:unpack(_)
end

DPUCard.SetBootOptionRsp = TSetBootOptionRsp

---@class DPUCard.SetBootOptionReq
---@field Mode integer
---@field Enabled integer
local TSetBootOptionReq = {}
TSetBootOptionReq.__index = TSetBootOptionReq
TSetBootOptionReq.group = {}

local function TSetBootOptionReq_from_obj(obj)
    return setmetatable(obj, TSetBootOptionReq)
end

function TSetBootOptionReq.new(Mode, Enabled)
    return TSetBootOptionReq_from_obj({Mode = Mode, Enabled = Enabled})
end
---@param obj DPUCard.SetBootOptionReq
function TSetBootOptionReq:init_from_obj(obj)
    self.Mode = obj.Mode
    self.Enabled = obj.Enabled
end

function TSetBootOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionReq.group)
end

TSetBootOptionReq.from_obj = TSetBootOptionReq_from_obj

TSetBootOptionReq.proto_property = {'Mode', 'Enabled'}

TSetBootOptionReq.default = {0, 0}

TSetBootOptionReq.struct = {
    {name = 'Mode', is_array = false, struct = nil}, {name = 'Enabled', is_array = false, struct = nil}
}

function TSetBootOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Enabled', self.Enabled, 'uint8', false, errs, need_convert)

    if self.Mode ~= nil then
        validate.Enum(prefix .. 'Mode', self.Mode, '', {0, 1, 2}, errs, need_convert)
    end
    if self.Enabled ~= nil then
        validate.Enum(prefix .. 'Enabled', self.Enabled, '', {0, 1}, errs, need_convert)
    end

    TSetBootOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionReq.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionReq:unpack(_)
    return self.Mode, self.Enabled
end

DPUCard.SetBootOptionReq = TSetBootOptionReq

---@class DPUCard.SetPowerStateRsp
local TSetPowerStateRsp = {}
TSetPowerStateRsp.__index = TSetPowerStateRsp
TSetPowerStateRsp.group = {}

local function TSetPowerStateRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerStateRsp)
end

function TSetPowerStateRsp.new()
    return TSetPowerStateRsp_from_obj({})
end
---@param obj DPUCard.SetPowerStateRsp
function TSetPowerStateRsp:init_from_obj(obj)

end

function TSetPowerStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerStateRsp.group)
end

TSetPowerStateRsp.from_obj = TSetPowerStateRsp_from_obj

TSetPowerStateRsp.proto_property = {}

TSetPowerStateRsp.default = {}

TSetPowerStateRsp.struct = {}

function TSetPowerStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPowerStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerStateRsp:unpack(_)
end

DPUCard.SetPowerStateRsp = TSetPowerStateRsp

---@class DPUCard.SetPowerStateReq
---@field PowerState integer
local TSetPowerStateReq = {}
TSetPowerStateReq.__index = TSetPowerStateReq
TSetPowerStateReq.group = {}

local function TSetPowerStateReq_from_obj(obj)
    return setmetatable(obj, TSetPowerStateReq)
end

function TSetPowerStateReq.new(PowerState)
    return TSetPowerStateReq_from_obj({PowerState = PowerState})
end
---@param obj DPUCard.SetPowerStateReq
function TSetPowerStateReq:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TSetPowerStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerStateReq.group)
end

TSetPowerStateReq.from_obj = TSetPowerStateReq_from_obj

TSetPowerStateReq.proto_property = {'PowerState'}

TSetPowerStateReq.default = {0}

TSetPowerStateReq.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TSetPowerStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', false, errs, need_convert)

    TSetPowerStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerStateReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerStateReq:unpack(_)
    return self.PowerState
end

DPUCard.SetPowerStateReq = TSetPowerStateReq

---@class DPUCard.ResetRsp
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new()
    return TResetRsp_from_obj({})
end
---@param obj DPUCard.ResetRsp
function TResetRsp:init_from_obj(obj)

end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {}

TResetRsp.default = {}

TResetRsp.struct = {}

function TResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetRsp:unpack(_)
end

DPUCard.ResetRsp = TResetRsp

---@class DPUCard.ResetReq
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new()
    return TResetReq_from_obj({})
end
---@param obj DPUCard.ResetReq
function TResetReq:init_from_obj(obj)

end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {}

TResetReq.default = {}

TResetReq.struct = {}

function TResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs, need_convert)
    return self
end

function TResetReq:unpack(_)
end

DPUCard.ResetReq = TResetReq

---@class DPUCard.SetDpuNmiRsp
local TSetDpuNmiRsp = {}
TSetDpuNmiRsp.__index = TSetDpuNmiRsp
TSetDpuNmiRsp.group = {}

local function TSetDpuNmiRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuNmiRsp)
end

function TSetDpuNmiRsp.new()
    return TSetDpuNmiRsp_from_obj({})
end
---@param obj DPUCard.SetDpuNmiRsp
function TSetDpuNmiRsp:init_from_obj(obj)

end

function TSetDpuNmiRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuNmiRsp.group)
end

TSetDpuNmiRsp.from_obj = TSetDpuNmiRsp_from_obj

TSetDpuNmiRsp.proto_property = {}

TSetDpuNmiRsp.default = {}

TSetDpuNmiRsp.struct = {}

function TSetDpuNmiRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetDpuNmiRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuNmiRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuNmiRsp:unpack(_)
end

DPUCard.SetDpuNmiRsp = TSetDpuNmiRsp

---@class DPUCard.SetDpuNmiReq
---@field SlotId integer
local TSetDpuNmiReq = {}
TSetDpuNmiReq.__index = TSetDpuNmiReq
TSetDpuNmiReq.group = {}

local function TSetDpuNmiReq_from_obj(obj)
    return setmetatable(obj, TSetDpuNmiReq)
end

function TSetDpuNmiReq.new(SlotId)
    return TSetDpuNmiReq_from_obj({SlotId = SlotId})
end
---@param obj DPUCard.SetDpuNmiReq
function TSetDpuNmiReq:init_from_obj(obj)
    self.SlotId = obj.SlotId
end

function TSetDpuNmiReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuNmiReq.group)
end

TSetDpuNmiReq.from_obj = TSetDpuNmiReq_from_obj

TSetDpuNmiReq.proto_property = {'SlotId'}

TSetDpuNmiReq.default = {0}

TSetDpuNmiReq.struct = {{name = 'SlotId', is_array = false, struct = nil}}

function TSetDpuNmiReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotId', self.SlotId, 'uint8', false, errs, need_convert)

    TSetDpuNmiReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuNmiReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuNmiReq:unpack(_)
    return self.SlotId
end

DPUCard.SetDpuNmiReq = TSetDpuNmiReq

---@class DPUCard.LogicVerObject
---@field key string
---@field value string
local TLogicVerObject = {}
TLogicVerObject.__index = TLogicVerObject
TLogicVerObject.group = {}

local function TLogicVerObject_from_obj(obj)
    return setmetatable(obj, TLogicVerObject)
end

function TLogicVerObject.new(dict)
    return TLogicVerObject_from_obj(dict)
end

---@param obj DPUCard.LogicVerObject
function TLogicVerObject:init_from_obj(obj)
    self = obj
end

function TLogicVerObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicVerObject.group)
end

TLogicVerObject.from_obj = TLogicVerObject_from_obj

TLogicVerObject.proto_property = {}

TLogicVerObject.default = {}

TLogicVerObject.struct = {}

function TLogicVerObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TLogicVerObject:remove_error_props(errs, self)
    return self
end

function TLogicVerObject:unpack(_)
    return self
end

DPUCard.LogicVerObject = TLogicVerObject

---@class DPUCard.MultiLogicVersion
---@field MultiLogicVersion DPUCard.LogicVerObject
local TMultiLogicVersion = {}
TMultiLogicVersion.__index = TMultiLogicVersion
TMultiLogicVersion.group = {}

local function TMultiLogicVersion_from_obj(obj)
    return setmetatable(obj, TMultiLogicVersion)
end

function TMultiLogicVersion.new(MultiLogicVersion)
    return TMultiLogicVersion_from_obj({MultiLogicVersion = MultiLogicVersion})
end
---@param obj DPUCard.MultiLogicVersion
function TMultiLogicVersion:init_from_obj(obj)
    self.MultiLogicVersion = obj.MultiLogicVersion
end

function TMultiLogicVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultiLogicVersion.group)
end

TMultiLogicVersion.from_obj = TMultiLogicVersion_from_obj

TMultiLogicVersion.proto_property = {'MultiLogicVersion'}

TMultiLogicVersion.default = {DPUCard.LogicVerObject.default}

TMultiLogicVersion.struct = {{name = 'MultiLogicVersion', is_array = false, struct = DPUCard.LogicVerObject.struct}}

function TMultiLogicVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    DPUCard.LogicVerObject.new(self.MultiLogicVersion):validate(prefix, errs, need_convert)

    TMultiLogicVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultiLogicVersion.proto_property, errs, need_convert)
    return self
end

function TMultiLogicVersion:unpack(_)
    return self.MultiLogicVersion
end

DPUCard.MultiLogicVersion = TMultiLogicVersion

---@class DPUCard.SystemLoadedStatus
---@field SystemLoadedStatus DPUCard.SystemBootStatus
local TSystemLoadedStatus = {}
TSystemLoadedStatus.__index = TSystemLoadedStatus
TSystemLoadedStatus.group = {}

local function TSystemLoadedStatus_from_obj(obj)
    obj.SystemLoadedStatus = obj.SystemLoadedStatus and DPUCard.SystemBootStatus.new(obj.SystemLoadedStatus)
    return setmetatable(obj, TSystemLoadedStatus)
end

function TSystemLoadedStatus.new(SystemLoadedStatus)
    return TSystemLoadedStatus_from_obj({SystemLoadedStatus = SystemLoadedStatus})
end
---@param obj DPUCard.SystemLoadedStatus
function TSystemLoadedStatus:init_from_obj(obj)
    self.SystemLoadedStatus = obj.SystemLoadedStatus
end

function TSystemLoadedStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemLoadedStatus.group)
end

TSystemLoadedStatus.from_obj = TSystemLoadedStatus_from_obj

TSystemLoadedStatus.proto_property = {'SystemLoadedStatus'}

TSystemLoadedStatus.default = {DPUCard.SystemBootStatus.default}

TSystemLoadedStatus.struct = {{name = 'SystemLoadedStatus', is_array = false, struct = DPUCard.SystemBootStatus.struct}}

function TSystemLoadedStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemLoadedStatus', self.SystemLoadedStatus, 'DPUCard.SystemBootStatus', true, errs,
        need_convert)

    TSystemLoadedStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemLoadedStatus.proto_property, errs, need_convert)
    return self
end

function TSystemLoadedStatus:unpack(raw)
    local SystemLoadedStatus = utils.unpack_enum(raw, self.SystemLoadedStatus)
    return SystemLoadedStatus
end

DPUCard.SystemLoadedStatus = TSystemLoadedStatus

---@class DPUCard.PfMacInfoItem
---@field Port integer
---@field PfId integer
---@field PermanentMac string
local TPfMacInfoItem = {}
TPfMacInfoItem.__index = TPfMacInfoItem
TPfMacInfoItem.group = {}

local function TPfMacInfoItem_from_obj(obj)
    return setmetatable(obj, TPfMacInfoItem)
end

function TPfMacInfoItem.new(Port, PfId, PermanentMac)
    return TPfMacInfoItem_from_obj({Port = Port, PfId = PfId, PermanentMac = PermanentMac})
end
---@param obj DPUCard.PfMacInfoItem
function TPfMacInfoItem:init_from_obj(obj)
    self.Port = obj.Port
    self.PfId = obj.PfId
    self.PermanentMac = obj.PermanentMac
end

function TPfMacInfoItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPfMacInfoItem.group)
end

TPfMacInfoItem.from_obj = TPfMacInfoItem_from_obj

TPfMacInfoItem.proto_property = {'Port', 'PfId', 'PermanentMac'}

TPfMacInfoItem.default = {0, 0, ''}

TPfMacInfoItem.struct = {
    {name = 'Port', is_array = false, struct = nil}, {name = 'PfId', is_array = false, struct = nil},
    {name = 'PermanentMac', is_array = false, struct = nil}
}

function TPfMacInfoItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port', self.Port, 'uint16', true, errs, need_convert)
    validate.Optional(prefix .. 'PfId', self.PfId, 'uint16', true, errs, need_convert)
    validate.Optional(prefix .. 'PermanentMac', self.PermanentMac, 'string', true, errs, need_convert)

    TPfMacInfoItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPfMacInfoItem.proto_property, errs, need_convert)
    return self
end

function TPfMacInfoItem:unpack(_)
    return self.Port, self.PfId, self.PermanentMac
end

DPUCard.PfMacInfoItem = TPfMacInfoItem

---@class DPUCard.PfMacInfo
---@field PfMacInfo DPUCard.PfMacInfoItem[]
local TPfMacInfo = {}
TPfMacInfo.__index = TPfMacInfo
TPfMacInfo.group = {}

local function TPfMacInfo_from_obj(obj)
    obj.PfMacInfo = utils.from_obj(DPUCard.PfMacInfoItem, obj.PfMacInfo, true)
    return setmetatable(obj, TPfMacInfo)
end

function TPfMacInfo.new(PfMacInfo)
    return TPfMacInfo_from_obj({PfMacInfo = PfMacInfo})
end
---@param obj DPUCard.PfMacInfo
function TPfMacInfo:init_from_obj(obj)
    self.PfMacInfo = obj.PfMacInfo
end

function TPfMacInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPfMacInfo.group)
end

TPfMacInfo.from_obj = TPfMacInfo_from_obj

TPfMacInfo.proto_property = {'PfMacInfo'}

TPfMacInfo.default = {{}}

TPfMacInfo.struct = {{name = 'PfMacInfo', is_array = true, struct = DPUCard.PfMacInfoItem.struct}}

function TPfMacInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.PfMacInfo) do
        DPUCard.PfMacInfoItem.new(v.Port, v.PfId, v.PermanentMac):validate(prefix, errs, need_convert)
    end

    TPfMacInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPfMacInfo.proto_property, errs, need_convert)
    return self
end

function TPfMacInfo:unpack(raw)
    return utils.unpack(raw, self.PfMacInfo, true)
end

DPUCard.PfMacInfo = TPfMacInfo

DPUCard.interface = mdb.register_interface('bmc.kepler.Systems.DPUCard', {
    BootSourceOverrideMode = {'y', nil, true, 255, false},
    PxeOption = {'s', nil, false, 'UefiIpv4', false},
    UUID = {'s', nil, true, nil, false},
    BootSourceOverrideEnabled = {'y', nil, true, 255, false},
    M2SlotMaxCount = {'y', nil, true, nil, false},
    NetworkAdapterMaxCount = {'y', nil, true, nil, false},
    Model = {'s', nil, true, nil, false},
    SystemLoadedStatus = {'i', {'EMIT_CHANGE'}, true, nil, false},
    SRVersion = {'s', nil, true, nil, false},
    UID = {'s', nil, true, nil, false},
    MRCLogLevel = {'y', nil, false, nil, false},
    UEFILogLevel = {'y', nil, false, nil, false},
    LogicVersion = {'s', nil, true, nil, false},
    MultiLogicVersion = {'a{ss}', {}, true, nil, false},
    CPLDCount = {'y', {}, true, 1, false},
    PowerState = {'s', {'EMIT_CHANGE'}, true, 'Off', false},
    MPUBusyStatus = {'y', {'EMIT_CHANGE'}, false, nil, false},
    VrdVersion = {'s', {}, true, nil, false},
    OSSupported = {'b', {}, true, true, false},
    StorageIpAddr = {'s', nil, true, nil, false},
    StorageIpVlan = {'q', nil, true, nil, false},
    M2SlotPresence = {'y', nil, true, nil, false},
    NetworkAdapterPresence = {'y', nil, true, nil, false},
    MCUVersion = {'s', nil, true, nil, false},
    PfMacInfo = {'a(qqs)', nil, true, nil, false}
}, {
    SetDpuNmi = {'a{ss}y', '', TSetDpuNmiReq, TSetDpuNmiRsp},
    Reset = {'a{ss}', '', TResetReq, TResetRsp},
    SetPowerState = {'a{ss}y', '', TSetPowerStateReq, TSetPowerStateRsp},
    SetBootOption = {'a{ss}yy', '', TSetBootOptionReq, TSetBootOptionRsp},
    ImportPublicKey = {'a{ss}ss', '', TImportPublicKeyReq, TImportPublicKeyRsp},
    SetLLDPStatus = {'a{ss}yy', '', TSetLLDPStatusReq, TSetLLDPStatusRsp},
    GetLLDPStatus = {'a{ss}y', 'y', TGetLLDPStatusReq, TGetLLDPStatusRsp}
}, {})

return DPUCard
