-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local Chip = {}

---@class Chip.SetLockStatusResultCode: Enum
local ESetLockStatusResultCode = create_enum_type('SetLockStatusResultCode')
ESetLockStatusResultCode.default = ESetLockStatusResultCode.new(2147483647)
ESetLockStatusResultCode.struct = nil
ESetLockStatusResultCode.OK = ESetLockStatusResultCode.new(0)
ESetLockStatusResultCode.InvalidParameter = ESetLockStatusResultCode.new(1)
ESetLockStatusResultCode.UnlockedError = ESetLockStatusResultCode.new(2)
ESetLockStatusResultCode.RequestorMismatchedError = ESetLockStatusResultCode.new(3)
ESetLockStatusResultCode.ChipMismatchedError = ESetLockStatusResultCode.new(4)
ESetLockStatusResultCode.ChannelMismatchedError = ESetLockStatusResultCode.new(5)

Chip.SetLockStatusResultCode = ESetLockStatusResultCode

---@class Chip.LockStatus
---@field LockStatus integer
local TLockStatus = {}
TLockStatus.__index = TLockStatus
TLockStatus.group = {}

local function TLockStatus_from_obj(obj)
    return setmetatable(obj, TLockStatus)
end

function TLockStatus.new(LockStatus)
    return TLockStatus_from_obj({LockStatus = LockStatus})
end
---@param obj Chip.LockStatus
function TLockStatus:init_from_obj(obj)
    self.LockStatus = obj.LockStatus
end

function TLockStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLockStatus.group)
end

TLockStatus.from_obj = TLockStatus_from_obj

TLockStatus.proto_property = {'LockStatus'}

TLockStatus.default = {0}

TLockStatus.struct = {{name = 'LockStatus', is_array = false, struct = nil}}

function TLockStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LockStatus', self.LockStatus, 'uint8', true, errs, need_convert)

    TLockStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLockStatus.proto_property, errs, need_convert)
    return self
end

function TLockStatus:unpack(_)
    return self.LockStatus
end

Chip.LockStatus = TLockStatus

---@class Chip.SelfTestResult
---@field SelfTestResult integer
local TSelfTestResult = {}
TSelfTestResult.__index = TSelfTestResult
TSelfTestResult.group = {}

local function TSelfTestResult_from_obj(obj)
    return setmetatable(obj, TSelfTestResult)
end

function TSelfTestResult.new(SelfTestResult)
    return TSelfTestResult_from_obj({SelfTestResult = SelfTestResult or 1})
end
---@param obj Chip.SelfTestResult
function TSelfTestResult:init_from_obj(obj)
    self.SelfTestResult = obj.SelfTestResult or 1
end

function TSelfTestResult:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelfTestResult.group)
end

TSelfTestResult.from_obj = TSelfTestResult_from_obj

TSelfTestResult.proto_property = {'SelfTestResult'}

TSelfTestResult.default = {0}

TSelfTestResult.struct = {{name = 'SelfTestResult', is_array = false, struct = nil}}

function TSelfTestResult:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SelfTestResult', self.SelfTestResult, 'uint8', true, errs, need_convert)

    TSelfTestResult:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelfTestResult.proto_property, errs, need_convert)
    return self
end

function TSelfTestResult:unpack(_)
    return self.SelfTestResult
end

Chip.SelfTestResult = TSelfTestResult

---@class Chip.PowerStatus
---@field PowerStatus integer
local TPowerStatus = {}
TPowerStatus.__index = TPowerStatus
TPowerStatus.group = {}

local function TPowerStatus_from_obj(obj)
    return setmetatable(obj, TPowerStatus)
end

function TPowerStatus.new(PowerStatus)
    return TPowerStatus_from_obj({PowerStatus = PowerStatus or 1})
end
---@param obj Chip.PowerStatus
function TPowerStatus:init_from_obj(obj)
    self.PowerStatus = obj.PowerStatus or 1
end

function TPowerStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerStatus.group)
end

TPowerStatus.from_obj = TPowerStatus_from_obj

TPowerStatus.proto_property = {'PowerStatus'}

TPowerStatus.default = {0}

TPowerStatus.struct = {{name = 'PowerStatus', is_array = false, struct = nil}}

function TPowerStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerStatus', self.PowerStatus, 'uint8', true, errs, need_convert)

    TPowerStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerStatus.proto_property, errs, need_convert)
    return self
end

function TPowerStatus:unpack(_)
    return self.PowerStatus
end

Chip.PowerStatus = TPowerStatus

---@class Chip.HealthStatus
---@field HealthStatus integer
local THealthStatus = {}
THealthStatus.__index = THealthStatus
THealthStatus.group = {}

local function THealthStatus_from_obj(obj)
    return setmetatable(obj, THealthStatus)
end

function THealthStatus.new(HealthStatus)
    return THealthStatus_from_obj({HealthStatus = HealthStatus or 0})
end
---@param obj Chip.HealthStatus
function THealthStatus:init_from_obj(obj)
    self.HealthStatus = obj.HealthStatus or 0
end

function THealthStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealthStatus.group)
end

THealthStatus.from_obj = THealthStatus_from_obj

THealthStatus.proto_property = {'HealthStatus'}

THealthStatus.default = {0}

THealthStatus.struct = {{name = 'HealthStatus', is_array = false, struct = nil}}

function THealthStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HealthStatus', self.HealthStatus, 'uint8', true, errs, need_convert)

    THealthStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealthStatus.proto_property, errs, need_convert)
    return self
end

function THealthStatus:unpack(_)
    return self.HealthStatus
end

Chip.HealthStatus = THealthStatus

---@class Chip.SetLockStatusRsp
---@field ResultCode Chip.SetLockStatusResultCode
local TSetLockStatusRsp = {}
TSetLockStatusRsp.__index = TSetLockStatusRsp
TSetLockStatusRsp.group = {}

local function TSetLockStatusRsp_from_obj(obj)
    obj.ResultCode = obj.ResultCode and Chip.SetLockStatusResultCode.new(obj.ResultCode)
    return setmetatable(obj, TSetLockStatusRsp)
end

function TSetLockStatusRsp.new(ResultCode)
    return TSetLockStatusRsp_from_obj({ResultCode = ResultCode})
end
---@param obj Chip.SetLockStatusRsp
function TSetLockStatusRsp:init_from_obj(obj)
    self.ResultCode = obj.ResultCode
end

function TSetLockStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLockStatusRsp.group)
end

TSetLockStatusRsp.from_obj = TSetLockStatusRsp_from_obj

TSetLockStatusRsp.proto_property = {'ResultCode'}

TSetLockStatusRsp.default = {Chip.SetLockStatusResultCode.default}

TSetLockStatusRsp.struct = {{name = 'ResultCode', is_array = false, struct = Chip.SetLockStatusResultCode.struct}}

function TSetLockStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResultCode', self.ResultCode, 'Chip.SetLockStatusResultCode', false, errs, need_convert)

    TSetLockStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLockStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetLockStatusRsp:unpack(raw)
    local ResultCode = utils.unpack_enum(raw, self.ResultCode)
    return ResultCode
end

Chip.SetLockStatusRsp = TSetLockStatusRsp

---@class Chip.SetLockStatusReq
---@field OpType integer
---@field LockTime integer
local TSetLockStatusReq = {}
TSetLockStatusReq.__index = TSetLockStatusReq
TSetLockStatusReq.group = {}

local function TSetLockStatusReq_from_obj(obj)
    return setmetatable(obj, TSetLockStatusReq)
end

function TSetLockStatusReq.new(OpType, LockTime)
    return TSetLockStatusReq_from_obj({OpType = OpType, LockTime = LockTime})
end
---@param obj Chip.SetLockStatusReq
function TSetLockStatusReq:init_from_obj(obj)
    self.OpType = obj.OpType
    self.LockTime = obj.LockTime
end

function TSetLockStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLockStatusReq.group)
end

TSetLockStatusReq.from_obj = TSetLockStatusReq_from_obj

TSetLockStatusReq.proto_property = {'OpType', 'LockTime'}

TSetLockStatusReq.default = {0, 0}

TSetLockStatusReq.struct = {
    {name = 'OpType', is_array = false, struct = nil}, {name = 'LockTime', is_array = false, struct = nil}
}

function TSetLockStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OpType', self.OpType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LockTime', self.LockTime, 'uint32', false, errs, need_convert)

    TSetLockStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLockStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetLockStatusReq:unpack(_)
    return self.OpType, self.LockTime
end

Chip.SetLockStatusReq = TSetLockStatusReq

---@class Chip.SetAccessibilityRsp
local TSetAccessibilityRsp = {}
TSetAccessibilityRsp.__index = TSetAccessibilityRsp
TSetAccessibilityRsp.group = {}

local function TSetAccessibilityRsp_from_obj(obj)
    return setmetatable(obj, TSetAccessibilityRsp)
end

function TSetAccessibilityRsp.new()
    return TSetAccessibilityRsp_from_obj({})
end
---@param obj Chip.SetAccessibilityRsp
function TSetAccessibilityRsp:init_from_obj(obj)

end

function TSetAccessibilityRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAccessibilityRsp.group)
end

TSetAccessibilityRsp.from_obj = TSetAccessibilityRsp_from_obj

TSetAccessibilityRsp.proto_property = {}

TSetAccessibilityRsp.default = {}

TSetAccessibilityRsp.struct = {}

function TSetAccessibilityRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetAccessibilityRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAccessibilityRsp.proto_property, errs, need_convert)
    return self
end

function TSetAccessibilityRsp:unpack(_)
end

Chip.SetAccessibilityRsp = TSetAccessibilityRsp

---@class Chip.SetAccessibilityReq
---@field Status boolean
---@field DisableDuration integer
local TSetAccessibilityReq = {}
TSetAccessibilityReq.__index = TSetAccessibilityReq
TSetAccessibilityReq.group = {}

local function TSetAccessibilityReq_from_obj(obj)
    return setmetatable(obj, TSetAccessibilityReq)
end

function TSetAccessibilityReq.new(Status, DisableDuration)
    return TSetAccessibilityReq_from_obj({Status = Status, DisableDuration = DisableDuration})
end
---@param obj Chip.SetAccessibilityReq
function TSetAccessibilityReq:init_from_obj(obj)
    self.Status = obj.Status
    self.DisableDuration = obj.DisableDuration
end

function TSetAccessibilityReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAccessibilityReq.group)
end

TSetAccessibilityReq.from_obj = TSetAccessibilityReq_from_obj

TSetAccessibilityReq.proto_property = {'Status', 'DisableDuration'}

TSetAccessibilityReq.default = {false, 0}

TSetAccessibilityReq.struct = {
    {name = 'Status', is_array = false, struct = nil}, {name = 'DisableDuration', is_array = false, struct = nil}
}

function TSetAccessibilityReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'DisableDuration', self.DisableDuration, 'uint16', false, errs, need_convert)

    TSetAccessibilityReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAccessibilityReq.proto_property, errs, need_convert)
    return self
end

function TSetAccessibilityReq:unpack(_)
    return self.Status, self.DisableDuration
end

Chip.SetAccessibilityReq = TSetAccessibilityReq

Chip.interface = mdb.register_interface('bmc.kepler.Chip', {
    HealthStatus = {'y', nil, true, 0, false},
    PowerStatus = {'y', nil, true, 1, false},
    SelfTestResult = {'y', nil, true, 1, false},
    LockStatus = {'y', {'EMIT_CHANGE'}, true, nil, false}
}, {
    SetAccessibility = {'a{ss}bq', '', TSetAccessibilityReq, TSetAccessibilityRsp},
    SetLockStatus = {'a{ss}yu', 'i', TSetLockStatusReq, TSetLockStatusRsp}
}, {})

return Chip
