--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuResetLinkage = {}

---@class GeneralHardwareIpmiCmds.SetDpuResetLinkageReq
---@field ManufactureId integer
---@field Reserved integer
---@field DeviceNo integer
---@field Offset integer
---@field ResetLinkage integer
local TSetDpuResetLinkageReq = {}
TSetDpuResetLinkageReq.__index = TSetDpuResetLinkageReq
TSetDpuResetLinkageReq.group = {}

local function TSetDpuResetLinkageReq_from_obj(obj)
    return setmetatable(obj, TSetDpuResetLinkageReq)
end

function TSetDpuResetLinkageReq.new(ManufactureId, Reserved, DeviceNo, Offset, ResetLinkage)
    return TSetDpuResetLinkageReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        DeviceNo = DeviceNo,
        Offset = Offset,
        ResetLinkage = ResetLinkage
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuResetLinkageReq
function TSetDpuResetLinkageReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.ResetLinkage = obj.ResetLinkage
end

function TSetDpuResetLinkageReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuResetLinkageReq.group)
end

TSetDpuResetLinkageReq.from_obj = TSetDpuResetLinkageReq_from_obj

TSetDpuResetLinkageReq.proto_property = {'ManufactureId', 'Reserved', 'DeviceNo', 'Offset', 'ResetLinkage'}

TSetDpuResetLinkageReq.default = {0, 0, 0, 0, 0}

TSetDpuResetLinkageReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'ResetLinkage', is_array = false, struct = nil}
}

function TSetDpuResetLinkageReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ResetLinkage', self.ResetLinkage, 'uint8', false, errs, need_convert)

    TSetDpuResetLinkageReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuResetLinkageReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuResetLinkageReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.DeviceNo, self.Offset, self.ResetLinkage
end

SetDpuResetLinkage.SetDpuResetLinkageReq = TSetDpuResetLinkageReq

---@class GeneralHardwareIpmiCmds.SetDpuResetLinkageRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuResetLinkageRsp = {}
TSetDpuResetLinkageRsp.__index = TSetDpuResetLinkageRsp
TSetDpuResetLinkageRsp.group = {}

local function TSetDpuResetLinkageRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuResetLinkageRsp)
end

function TSetDpuResetLinkageRsp.new(CompletionCode, ManufactureId)
    return TSetDpuResetLinkageRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuResetLinkageRsp
function TSetDpuResetLinkageRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuResetLinkageRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuResetLinkageRsp.group)
end

TSetDpuResetLinkageRsp.from_obj = TSetDpuResetLinkageRsp_from_obj

TSetDpuResetLinkageRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuResetLinkageRsp.default = {0, 0}

TSetDpuResetLinkageRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuResetLinkageRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuResetLinkageRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuResetLinkageRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuResetLinkageRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuResetLinkage.SetDpuResetLinkageRsp = TSetDpuResetLinkageRsp

return SetDpuResetLinkage
