--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuPxeOption = {}

---@class GeneralHardwareIpmiCmds.SetDpuPxeOptionReq
---@field ManufactureId integer
---@field Rsvd integer
---@field DeviceNo integer
---@field Offset integer
---@field PxeOption integer
local TSetDpuPxeOptionReq = {}
TSetDpuPxeOptionReq.__index = TSetDpuPxeOptionReq
TSetDpuPxeOptionReq.group = {}

local function TSetDpuPxeOptionReq_from_obj(obj)
    return setmetatable(obj, TSetDpuPxeOptionReq)
end

function TSetDpuPxeOptionReq.new(ManufactureId, Rsvd, DeviceNo, Offset, PxeOption)
    return TSetDpuPxeOptionReq_from_obj({
        ManufactureId = ManufactureId,
        Rsvd = Rsvd,
        DeviceNo = DeviceNo,
        Offset = Offset,
        PxeOption = PxeOption
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuPxeOptionReq
function TSetDpuPxeOptionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Rsvd = obj.Rsvd
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.PxeOption = obj.PxeOption
end

function TSetDpuPxeOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuPxeOptionReq.group)
end

TSetDpuPxeOptionReq.from_obj = TSetDpuPxeOptionReq_from_obj

TSetDpuPxeOptionReq.proto_property = {'ManufactureId', 'Rsvd', 'DeviceNo', 'Offset', 'PxeOption'}

TSetDpuPxeOptionReq.default = {0, 0, 0, 0, 0}

TSetDpuPxeOptionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Rsvd', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'PxeOption', is_array = false, struct = nil}
}

function TSetDpuPxeOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Rsvd', self.Rsvd, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'PxeOption', self.PxeOption, 'uint8', false, errs, need_convert)

    TSetDpuPxeOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuPxeOptionReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuPxeOptionReq:unpack(_)
    return self.ManufactureId, self.Rsvd, self.DeviceNo, self.Offset, self.PxeOption
end

SetDpuPxeOption.SetDpuPxeOptionReq = TSetDpuPxeOptionReq

---@class GeneralHardwareIpmiCmds.SetDpuPxeOptionRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuPxeOptionRsp = {}
TSetDpuPxeOptionRsp.__index = TSetDpuPxeOptionRsp
TSetDpuPxeOptionRsp.group = {}

local function TSetDpuPxeOptionRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuPxeOptionRsp)
end

function TSetDpuPxeOptionRsp.new(CompletionCode, ManufactureId)
    return TSetDpuPxeOptionRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuPxeOptionRsp
function TSetDpuPxeOptionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuPxeOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuPxeOptionRsp.group)
end

TSetDpuPxeOptionRsp.from_obj = TSetDpuPxeOptionRsp_from_obj

TSetDpuPxeOptionRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuPxeOptionRsp.default = {0, 0}

TSetDpuPxeOptionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuPxeOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuPxeOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuPxeOptionRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuPxeOptionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuPxeOption.SetDpuPxeOptionRsp = TSetDpuPxeOptionRsp

return SetDpuPxeOption
