--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuBootOption = {}

---@class GeneralHardwareIpmiCmds.SetDpuBootOptionReq
---@field ManufactureId integer
---@field Rsvd integer
---@field DeviceNo integer
---@field Offset integer
---@field BootOrder integer
---@field BootValidType integer
local TSetDpuBootOptionReq = {}
TSetDpuBootOptionReq.__index = TSetDpuBootOptionReq
TSetDpuBootOptionReq.group = {}

local function TSetDpuBootOptionReq_from_obj(obj)
    return setmetatable(obj, TSetDpuBootOptionReq)
end

function TSetDpuBootOptionReq.new(ManufactureId, Rsvd, DeviceNo, Offset, BootOrder, BootValidType)
    return TSetDpuBootOptionReq_from_obj({
        ManufactureId = ManufactureId,
        Rsvd = Rsvd,
        DeviceNo = DeviceNo,
        Offset = Offset,
        BootOrder = BootOrder,
        BootValidType = BootValidType
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuBootOptionReq
function TSetDpuBootOptionReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Rsvd = obj.Rsvd
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.BootOrder = obj.BootOrder
    self.BootValidType = obj.BootValidType
end

function TSetDpuBootOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuBootOptionReq.group)
end

TSetDpuBootOptionReq.from_obj = TSetDpuBootOptionReq_from_obj

TSetDpuBootOptionReq.proto_property = {'ManufactureId', 'Rsvd', 'DeviceNo', 'Offset', 'BootOrder', 'BootValidType'}

TSetDpuBootOptionReq.default = {0, 0, 0, 0, 0, 0}

TSetDpuBootOptionReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Rsvd', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'BootOrder', is_array = false, struct = nil}, {name = 'BootValidType', is_array = false, struct = nil}
}

function TSetDpuBootOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Rsvd', self.Rsvd, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'BootOrder', self.BootOrder, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BootValidType', self.BootValidType, 'uint8', false, errs, need_convert)

    TSetDpuBootOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuBootOptionReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuBootOptionReq:unpack(_)
    return self.ManufactureId, self.Rsvd, self.DeviceNo, self.Offset, self.BootOrder, self.BootValidType
end

SetDpuBootOption.SetDpuBootOptionReq = TSetDpuBootOptionReq

---@class GeneralHardwareIpmiCmds.SetDpuBootOptionRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuBootOptionRsp = {}
TSetDpuBootOptionRsp.__index = TSetDpuBootOptionRsp
TSetDpuBootOptionRsp.group = {}

local function TSetDpuBootOptionRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuBootOptionRsp)
end

function TSetDpuBootOptionRsp.new(CompletionCode, ManufactureId)
    return TSetDpuBootOptionRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuBootOptionRsp
function TSetDpuBootOptionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuBootOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuBootOptionRsp.group)
end

TSetDpuBootOptionRsp.from_obj = TSetDpuBootOptionRsp_from_obj

TSetDpuBootOptionRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuBootOptionRsp.default = {0, 0}

TSetDpuBootOptionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuBootOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuBootOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuBootOptionRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuBootOptionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuBootOption.SetDpuBootOptionRsp = TSetDpuBootOptionRsp

return SetDpuBootOption
