--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuBiosLogLevel = {}

---@class GeneralHardwareIpmiCmds.SetDpuBiosLogLevelReq
---@field ManufactureId integer
---@field Reserved integer
---@field DeviceNo integer
---@field Offset integer
---@field Length integer
---@field Type integer
---@field Level integer
local TSetDpuBiosLogLevelReq = {}
TSetDpuBiosLogLevelReq.__index = TSetDpuBiosLogLevelReq
TSetDpuBiosLogLevelReq.group = {}

local function TSetDpuBiosLogLevelReq_from_obj(obj)
    return setmetatable(obj, TSetDpuBiosLogLevelReq)
end

function TSetDpuBiosLogLevelReq.new(ManufactureId, Reserved, DeviceNo, Offset, Length, Type, Level)
    return TSetDpuBiosLogLevelReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Length = Length,
        Type = Type,
        Level = Level
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuBiosLogLevelReq
function TSetDpuBiosLogLevelReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Type = obj.Type
    self.Level = obj.Level
end

function TSetDpuBiosLogLevelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuBiosLogLevelReq.group)
end

TSetDpuBiosLogLevelReq.from_obj = TSetDpuBiosLogLevelReq_from_obj

TSetDpuBiosLogLevelReq.proto_property = {'ManufactureId', 'Reserved', 'DeviceNo', 'Offset', 'Length', 'Type', 'Level'}

TSetDpuBiosLogLevelReq.default = {0, 0, 0, 0, 0, 0, 0}

TSetDpuBiosLogLevelReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil},
    {name = 'Level', is_array = false, struct = nil}
}

function TSetDpuBiosLogLevelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Level', self.Level, 'uint8', false, errs, need_convert)

    TSetDpuBiosLogLevelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuBiosLogLevelReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuBiosLogLevelReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.DeviceNo, self.Offset, self.Length, self.Type, self.Level
end

SetDpuBiosLogLevel.SetDpuBiosLogLevelReq = TSetDpuBiosLogLevelReq

---@class GeneralHardwareIpmiCmds.SetDpuBiosLogLevelRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuBiosLogLevelRsp = {}
TSetDpuBiosLogLevelRsp.__index = TSetDpuBiosLogLevelRsp
TSetDpuBiosLogLevelRsp.group = {}

local function TSetDpuBiosLogLevelRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuBiosLogLevelRsp)
end

function TSetDpuBiosLogLevelRsp.new(CompletionCode, ManufactureId)
    return TSetDpuBiosLogLevelRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuBiosLogLevelRsp
function TSetDpuBiosLogLevelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuBiosLogLevelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuBiosLogLevelRsp.group)
end

TSetDpuBiosLogLevelRsp.from_obj = TSetDpuBiosLogLevelRsp_from_obj

TSetDpuBiosLogLevelRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuBiosLogLevelRsp.default = {0, 0}

TSetDpuBiosLogLevelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuBiosLogLevelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuBiosLogLevelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuBiosLogLevelRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuBiosLogLevelRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuBiosLogLevel.SetDpuBiosLogLevelRsp = TSetDpuBiosLogLevelRsp

return SetDpuBiosLogLevel
