--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReportTrustedModuleInfo = {}

---@class GeneralHardwareIpmiCmds.ReportTrustedModuleInfoReq
---@field ManufactureId integer
---@field TrustedModuleInfo string
local TReportTrustedModuleInfoReq = {}
TReportTrustedModuleInfoReq.__index = TReportTrustedModuleInfoReq
TReportTrustedModuleInfoReq.group = {}

local function TReportTrustedModuleInfoReq_from_obj(obj)
    return setmetatable(obj, TReportTrustedModuleInfoReq)
end

function TReportTrustedModuleInfoReq.new(ManufactureId, TrustedModuleInfo)
    return TReportTrustedModuleInfoReq_from_obj({ManufactureId = ManufactureId, TrustedModuleInfo = TrustedModuleInfo})
end
---@param obj GeneralHardwareIpmiCmds.ReportTrustedModuleInfoReq
function TReportTrustedModuleInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.TrustedModuleInfo = obj.TrustedModuleInfo
end

function TReportTrustedModuleInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReportTrustedModuleInfoReq.group)
end

TReportTrustedModuleInfoReq.from_obj = TReportTrustedModuleInfoReq_from_obj

TReportTrustedModuleInfoReq.proto_property = {'ManufactureId', 'TrustedModuleInfo'}

TReportTrustedModuleInfoReq.default = {0, ''}

TReportTrustedModuleInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'TrustedModuleInfo', is_array = false, struct = nil}
}

function TReportTrustedModuleInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'TrustedModuleInfo', self.TrustedModuleInfo, 'string', false, errs, need_convert)

    TReportTrustedModuleInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReportTrustedModuleInfoReq.proto_property, errs, need_convert)
    return self
end

function TReportTrustedModuleInfoReq:unpack(_)
    return self.ManufactureId, self.TrustedModuleInfo
end

ReportTrustedModuleInfo.ReportTrustedModuleInfoReq = TReportTrustedModuleInfoReq

---@class GeneralHardwareIpmiCmds.ReportTrustedModuleInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TReportTrustedModuleInfoRsp = {}
TReportTrustedModuleInfoRsp.__index = TReportTrustedModuleInfoRsp
TReportTrustedModuleInfoRsp.group = {}

local function TReportTrustedModuleInfoRsp_from_obj(obj)
    return setmetatable(obj, TReportTrustedModuleInfoRsp)
end

function TReportTrustedModuleInfoRsp.new(CompletionCode, ManufactureId)
    return TReportTrustedModuleInfoRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.ReportTrustedModuleInfoRsp
function TReportTrustedModuleInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TReportTrustedModuleInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReportTrustedModuleInfoRsp.group)
end

TReportTrustedModuleInfoRsp.from_obj = TReportTrustedModuleInfoRsp_from_obj

TReportTrustedModuleInfoRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TReportTrustedModuleInfoRsp.default = {0, 0}

TReportTrustedModuleInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TReportTrustedModuleInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TReportTrustedModuleInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReportTrustedModuleInfoRsp.proto_property, errs, need_convert)
    return self
end

function TReportTrustedModuleInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

ReportTrustedModuleInfo.ReportTrustedModuleInfoRsp = TReportTrustedModuleInfoRsp

return ReportTrustedModuleInfo
