-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MVRDFirmware = {}

---@class MVRDFirmware.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MVRDFirmware.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MVRDFirmware.RefChip = TRefChip

---@class MVRDFirmware.SoftwareId
---@field SoftwareId string
local TSoftwareId = {}
TSoftwareId.__index = TSoftwareId
TSoftwareId.group = {}

local function TSoftwareId_from_obj(obj)
    return setmetatable(obj, TSoftwareId)
end

function TSoftwareId.new(SoftwareId)
    return TSoftwareId_from_obj({SoftwareId = SoftwareId})
end
---@param obj MVRDFirmware.SoftwareId
function TSoftwareId:init_from_obj(obj)
    self.SoftwareId = obj.SoftwareId
end

function TSoftwareId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSoftwareId.group)
end

TSoftwareId.from_obj = TSoftwareId_from_obj

TSoftwareId.proto_property = {'SoftwareId'}

TSoftwareId.default = {''}

TSoftwareId.struct = {{name = 'SoftwareId', is_array = false, struct = nil}}

function TSoftwareId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SoftwareId', self.SoftwareId, 'string', false, errs, need_convert)

    TSoftwareId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSoftwareId.proto_property, errs, need_convert)
    return self
end

function TSoftwareId:unpack(_)
    return self.SoftwareId
end

MVRDFirmware.SoftwareId = TSoftwareId

---@class MVRDFirmware.ChipType
---@field ChipType string
local TChipType = {}
TChipType.__index = TChipType
TChipType.group = {}

local function TChipType_from_obj(obj)
    return setmetatable(obj, TChipType)
end

function TChipType.new(ChipType)
    return TChipType_from_obj({ChipType = ChipType})
end
---@param obj MVRDFirmware.ChipType
function TChipType:init_from_obj(obj)
    self.ChipType = obj.ChipType
end

function TChipType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipType.group)
end

TChipType.from_obj = TChipType_from_obj

TChipType.proto_property = {'ChipType'}

TChipType.default = {''}

TChipType.struct = {{name = 'ChipType', is_array = false, struct = nil}}

function TChipType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipType', self.ChipType, 'string', false, errs, need_convert)

    TChipType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipType.proto_property, errs, need_convert)
    return self
end

function TChipType:unpack(_)
    return self.ChipType
end

MVRDFirmware.ChipType = TChipType

---@class MVRDFirmware.BoardType
---@field BoardType string
local TBoardType = {}
TBoardType.__index = TBoardType
TBoardType.group = {}

local function TBoardType_from_obj(obj)
    return setmetatable(obj, TBoardType)
end

function TBoardType.new(BoardType)
    return TBoardType_from_obj({BoardType = BoardType})
end
---@param obj MVRDFirmware.BoardType
function TBoardType:init_from_obj(obj)
    self.BoardType = obj.BoardType
end

function TBoardType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBoardType.group)
end

TBoardType.from_obj = TBoardType_from_obj

TBoardType.proto_property = {'BoardType'}

TBoardType.default = {''}

TBoardType.struct = {{name = 'BoardType', is_array = false, struct = nil}}

function TBoardType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BoardType', self.BoardType, 'string', false, errs, need_convert)

    TBoardType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBoardType.proto_property, errs, need_convert)
    return self
end

function TBoardType:unpack(_)
    return self.BoardType
end

MVRDFirmware.BoardType = TBoardType

---@class MVRDFirmware.UID
---@field UID string
local TUID = {}
TUID.__index = TUID
TUID.group = {}

local function TUID_from_obj(obj)
    return setmetatable(obj, TUID)
end

function TUID.new(UID)
    return TUID_from_obj({UID = UID})
end
---@param obj MVRDFirmware.UID
function TUID:init_from_obj(obj)
    self.UID = obj.UID
end

function TUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUID.group)
end

TUID.from_obj = TUID_from_obj

TUID.proto_property = {'UID'}

TUID.default = {''}

TUID.struct = {{name = 'UID', is_array = false, struct = nil}}

function TUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', false, errs, need_convert)

    TUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUID.proto_property, errs, need_convert)
    return self
end

function TUID:unpack(_)
    return self.UID
end

MVRDFirmware.UID = TUID

return MVRDFirmware
