-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MRetimer = {}

---@class MRetimer.FirmwareStorageChip
---@field FirmwareStorageChip integer[]
local TFirmwareStorageChip = {}
TFirmwareStorageChip.__index = TFirmwareStorageChip
TFirmwareStorageChip.group = {}

local function TFirmwareStorageChip_from_obj(obj)
    return setmetatable(obj, TFirmwareStorageChip)
end

function TFirmwareStorageChip.new(FirmwareStorageChip)
    return TFirmwareStorageChip_from_obj({FirmwareStorageChip = FirmwareStorageChip})
end
---@param obj MRetimer.FirmwareStorageChip
function TFirmwareStorageChip:init_from_obj(obj)
    self.FirmwareStorageChip = obj.FirmwareStorageChip
end

function TFirmwareStorageChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareStorageChip.group)
end

TFirmwareStorageChip.from_obj = TFirmwareStorageChip_from_obj

TFirmwareStorageChip.proto_property = {'FirmwareStorageChip'}

TFirmwareStorageChip.default = {{}}

TFirmwareStorageChip.struct = {{name = 'FirmwareStorageChip', is_array = true, struct = nil}}

function TFirmwareStorageChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FirmwareStorageChip',
        self.FirmwareStorageChip, 'uint8', false, errs, need_convert)

    TFirmwareStorageChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareStorageChip.proto_property, errs, need_convert)
    return self
end

function TFirmwareStorageChip:unpack(_)
    return self.FirmwareStorageChip
end

MRetimer.FirmwareStorageChip = TFirmwareStorageChip

---@class MRetimer.ComponentIDEx
---@field ComponentIDEx integer
local TComponentIDEx = {}
TComponentIDEx.__index = TComponentIDEx
TComponentIDEx.group = {}

local function TComponentIDEx_from_obj(obj)
    return setmetatable(obj, TComponentIDEx)
end

function TComponentIDEx.new(ComponentIDEx)
    return TComponentIDEx_from_obj({ComponentIDEx = ComponentIDEx or 0})
end
---@param obj MRetimer.ComponentIDEx
function TComponentIDEx:init_from_obj(obj)
    self.ComponentIDEx = obj.ComponentIDEx or 0
end

function TComponentIDEx:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComponentIDEx.group)
end

TComponentIDEx.from_obj = TComponentIDEx_from_obj

TComponentIDEx.proto_property = {'ComponentIDEx'}

TComponentIDEx.default = {0}

TComponentIDEx.struct = {{name = 'ComponentIDEx', is_array = false, struct = nil}}

function TComponentIDEx:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentIDEx', self.ComponentIDEx, 'uint32', false, errs, need_convert)

    TComponentIDEx:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComponentIDEx.proto_property, errs, need_convert)
    return self
end

function TComponentIDEx:unpack(_)
    return self.ComponentIDEx
end

MRetimer.ComponentIDEx = TComponentIDEx

---@class MRetimer.IpmiChannelId
---@field IpmiChannelId integer
local TIpmiChannelId = {}
TIpmiChannelId.__index = TIpmiChannelId
TIpmiChannelId.group = {}

local function TIpmiChannelId_from_obj(obj)
    return setmetatable(obj, TIpmiChannelId)
end

function TIpmiChannelId.new(IpmiChannelId)
    return TIpmiChannelId_from_obj({IpmiChannelId = IpmiChannelId})
end
---@param obj MRetimer.IpmiChannelId
function TIpmiChannelId:init_from_obj(obj)
    self.IpmiChannelId = obj.IpmiChannelId
end

function TIpmiChannelId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiChannelId.group)
end

TIpmiChannelId.from_obj = TIpmiChannelId_from_obj

TIpmiChannelId.proto_property = {'IpmiChannelId'}

TIpmiChannelId.default = {0}

TIpmiChannelId.struct = {{name = 'IpmiChannelId', is_array = false, struct = nil}}

function TIpmiChannelId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IpmiChannelId', self.IpmiChannelId, 'uint8', false, errs, need_convert)

    TIpmiChannelId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiChannelId.proto_property, errs, need_convert)
    return self
end

function TIpmiChannelId:unpack(_)
    return self.IpmiChannelId
end

MRetimer.IpmiChannelId = TIpmiChannelId

---@class MRetimer.Switch
---@field Switch integer
local TSwitch = {}
TSwitch.__index = TSwitch
TSwitch.group = {}

local function TSwitch_from_obj(obj)
    return setmetatable(obj, TSwitch)
end

function TSwitch.new(Switch)
    return TSwitch_from_obj({Switch = Switch})
end
---@param obj MRetimer.Switch
function TSwitch:init_from_obj(obj)
    self.Switch = obj.Switch
end

function TSwitch:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSwitch.group)
end

TSwitch.from_obj = TSwitch_from_obj

TSwitch.proto_property = {'Switch'}

TSwitch.default = {0}

TSwitch.struct = {{name = 'Switch', is_array = false, struct = nil}}

function TSwitch:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Switch', self.Switch, 'uint8', false, errs, need_convert)

    TSwitch:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSwitch.proto_property, errs, need_convert)
    return self
end

function TSwitch:unpack(_)
    return self.Switch
end

MRetimer.Switch = TSwitch

---@class MRetimer.LinkStatus
---@field LinkStatus integer
local TLinkStatus = {}
TLinkStatus.__index = TLinkStatus
TLinkStatus.group = {}

local function TLinkStatus_from_obj(obj)
    return setmetatable(obj, TLinkStatus)
end

function TLinkStatus.new(LinkStatus)
    return TLinkStatus_from_obj({LinkStatus = LinkStatus})
end
---@param obj MRetimer.LinkStatus
function TLinkStatus:init_from_obj(obj)
    self.LinkStatus = obj.LinkStatus
end

function TLinkStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkStatus.group)
end

TLinkStatus.from_obj = TLinkStatus_from_obj

TLinkStatus.proto_property = {'LinkStatus'}

TLinkStatus.default = {0}

TLinkStatus.struct = {{name = 'LinkStatus', is_array = false, struct = nil}}

function TLinkStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkStatus', self.LinkStatus, 'uint8', false, errs, need_convert)

    TLinkStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkStatus.proto_property, errs, need_convert)
    return self
end

function TLinkStatus:unpack(_)
    return self.LinkStatus
end

MRetimer.LinkStatus = TLinkStatus

---@class MRetimer.Reset
---@field Reset integer
local TReset = {}
TReset.__index = TReset
TReset.group = {}

local function TReset_from_obj(obj)
    return setmetatable(obj, TReset)
end

function TReset.new(Reset)
    return TReset_from_obj({Reset = Reset})
end
---@param obj MRetimer.Reset
function TReset:init_from_obj(obj)
    self.Reset = obj.Reset
end

function TReset:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReset.group)
end

TReset.from_obj = TReset_from_obj

TReset.proto_property = {'Reset'}

TReset.default = {0}

TReset.struct = {{name = 'Reset', is_array = false, struct = nil}}

function TReset:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reset', self.Reset, 'uint8', false, errs, need_convert)

    TReset:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReset.proto_property, errs, need_convert)
    return self
end

function TReset:unpack(_)
    return self.Reset
end

MRetimer.Reset = TReset

---@class MRetimer.ReqAccNotify
---@field ReqAccNotify integer
local TReqAccNotify = {}
TReqAccNotify.__index = TReqAccNotify
TReqAccNotify.group = {}

local function TReqAccNotify_from_obj(obj)
    return setmetatable(obj, TReqAccNotify)
end

function TReqAccNotify.new(ReqAccNotify)
    return TReqAccNotify_from_obj({ReqAccNotify = ReqAccNotify})
end
---@param obj MRetimer.ReqAccNotify
function TReqAccNotify:init_from_obj(obj)
    self.ReqAccNotify = obj.ReqAccNotify
end

function TReqAccNotify:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReqAccNotify.group)
end

TReqAccNotify.from_obj = TReqAccNotify_from_obj

TReqAccNotify.proto_property = {'ReqAccNotify'}

TReqAccNotify.default = {0}

TReqAccNotify.struct = {{name = 'ReqAccNotify', is_array = false, struct = nil}}

function TReqAccNotify:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReqAccNotify', self.ReqAccNotify, 'uint8', false, errs, need_convert)

    TReqAccNotify:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReqAccNotify.proto_property, errs, need_convert)
    return self
end

function TReqAccNotify:unpack(_)
    return self.ReqAccNotify
end

MRetimer.ReqAccNotify = TReqAccNotify

---@class MRetimer.UpgradeGroup
---@field UpgradeGroup integer
local TUpgradeGroup = {}
TUpgradeGroup.__index = TUpgradeGroup
TUpgradeGroup.group = {}

local function TUpgradeGroup_from_obj(obj)
    return setmetatable(obj, TUpgradeGroup)
end

function TUpgradeGroup.new(UpgradeGroup)
    return TUpgradeGroup_from_obj({UpgradeGroup = UpgradeGroup})
end
---@param obj MRetimer.UpgradeGroup
function TUpgradeGroup:init_from_obj(obj)
    self.UpgradeGroup = obj.UpgradeGroup
end

function TUpgradeGroup:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeGroup.group)
end

TUpgradeGroup.from_obj = TUpgradeGroup_from_obj

TUpgradeGroup.proto_property = {'UpgradeGroup'}

TUpgradeGroup.default = {0}

TUpgradeGroup.struct = {{name = 'UpgradeGroup', is_array = false, struct = nil}}

function TUpgradeGroup:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradeGroup', self.UpgradeGroup, 'uint8', false, errs, need_convert)

    TUpgradeGroup:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeGroup.proto_property, errs, need_convert)
    return self
end

function TUpgradeGroup:unpack(_)
    return self.UpgradeGroup
end

MRetimer.UpgradeGroup = TUpgradeGroup

---@class MRetimer.ChipVersion
---@field ChipVersion string
local TChipVersion = {}
TChipVersion.__index = TChipVersion
TChipVersion.group = {}

local function TChipVersion_from_obj(obj)
    return setmetatable(obj, TChipVersion)
end

function TChipVersion.new(ChipVersion)
    return TChipVersion_from_obj({ChipVersion = ChipVersion})
end
---@param obj MRetimer.ChipVersion
function TChipVersion:init_from_obj(obj)
    self.ChipVersion = obj.ChipVersion
end

function TChipVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipVersion.group)
end

TChipVersion.from_obj = TChipVersion_from_obj

TChipVersion.proto_property = {'ChipVersion'}

TChipVersion.default = {''}

TChipVersion.struct = {{name = 'ChipVersion', is_array = false, struct = nil}}

function TChipVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipVersion', self.ChipVersion, 'string', false, errs, need_convert)

    TChipVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipVersion.proto_property, errs, need_convert)
    return self
end

function TChipVersion:unpack(_)
    return self.ChipVersion
end

MRetimer.ChipVersion = TChipVersion

---@class MRetimer.LockChip
---@field LockChip integer[]
local TLockChip = {}
TLockChip.__index = TLockChip
TLockChip.group = {}

local function TLockChip_from_obj(obj)
    return setmetatable(obj, TLockChip)
end

function TLockChip.new(LockChip)
    return TLockChip_from_obj({LockChip = LockChip})
end
---@param obj MRetimer.LockChip
function TLockChip:init_from_obj(obj)
    self.LockChip = obj.LockChip
end

function TLockChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLockChip.group)
end

TLockChip.from_obj = TLockChip_from_obj

TLockChip.proto_property = {'LockChip'}

TLockChip.default = {{}}

TLockChip.struct = {{name = 'LockChip', is_array = true, struct = nil}}

function TLockChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LockChip', self.LockChip, 'uint8', false, errs, need_convert)

    TLockChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLockChip.proto_property, errs, need_convert)
    return self
end

function TLockChip:unpack(_)
    return self.LockChip
end

MRetimer.LockChip = TLockChip

---@class MRetimer.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MRetimer.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MRetimer.RefChip = TRefChip

---@class MRetimer.LoadSequence
---@field LoadSequence integer
local TLoadSequence = {}
TLoadSequence.__index = TLoadSequence
TLoadSequence.group = {}

local function TLoadSequence_from_obj(obj)
    return setmetatable(obj, TLoadSequence)
end

function TLoadSequence.new(LoadSequence)
    return TLoadSequence_from_obj({LoadSequence = LoadSequence})
end
---@param obj MRetimer.LoadSequence
function TLoadSequence:init_from_obj(obj)
    self.LoadSequence = obj.LoadSequence
end

function TLoadSequence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLoadSequence.group)
end

TLoadSequence.from_obj = TLoadSequence_from_obj

TLoadSequence.proto_property = {'LoadSequence'}

TLoadSequence.default = {0}

TLoadSequence.struct = {{name = 'LoadSequence', is_array = false, struct = nil}}

function TLoadSequence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LoadSequence', self.LoadSequence, 'uint8', false, errs, need_convert)

    TLoadSequence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLoadSequence.proto_property, errs, need_convert)
    return self
end

function TLoadSequence:unpack(_)
    return self.LoadSequence
end

MRetimer.LoadSequence = TLoadSequence

---@class MRetimer.RetimerId
---@field RetimerId integer
local TRetimerId = {}
TRetimerId.__index = TRetimerId
TRetimerId.group = {}

local function TRetimerId_from_obj(obj)
    return setmetatable(obj, TRetimerId)
end

function TRetimerId.new(RetimerId)
    return TRetimerId_from_obj({RetimerId = RetimerId})
end
---@param obj MRetimer.RetimerId
function TRetimerId:init_from_obj(obj)
    self.RetimerId = obj.RetimerId
end

function TRetimerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRetimerId.group)
end

TRetimerId.from_obj = TRetimerId_from_obj

TRetimerId.proto_property = {'RetimerId'}

TRetimerId.default = {0}

TRetimerId.struct = {{name = 'RetimerId', is_array = false, struct = nil}}

function TRetimerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RetimerId', self.RetimerId, 'uint8', false, errs, need_convert)

    TRetimerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRetimerId.proto_property, errs, need_convert)
    return self
end

function TRetimerId:unpack(_)
    return self.RetimerId
end

MRetimer.RetimerId = TRetimerId

return MRetimer
