-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNpuBoard = {}

---@class MNpuBoard.ComputingUnitResetLocked
---@field ComputingUnitResetLocked integer
local TComputingUnitResetLocked = {}
TComputingUnitResetLocked.__index = TComputingUnitResetLocked
TComputingUnitResetLocked.group = {}

local function TComputingUnitResetLocked_from_obj(obj)
    return setmetatable(obj, TComputingUnitResetLocked)
end

function TComputingUnitResetLocked.new(ComputingUnitResetLocked)
    return TComputingUnitResetLocked_from_obj({ComputingUnitResetLocked = ComputingUnitResetLocked or 0})
end
---@param obj MNpuBoard.ComputingUnitResetLocked
function TComputingUnitResetLocked:init_from_obj(obj)
    self.ComputingUnitResetLocked = obj.ComputingUnitResetLocked or 0
end

function TComputingUnitResetLocked:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComputingUnitResetLocked.group)
end

TComputingUnitResetLocked.from_obj = TComputingUnitResetLocked_from_obj

TComputingUnitResetLocked.proto_property = {'ComputingUnitResetLocked'}

TComputingUnitResetLocked.default = {0}

TComputingUnitResetLocked.struct = {{name = 'ComputingUnitResetLocked', is_array = false, struct = nil}}

function TComputingUnitResetLocked:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComputingUnitResetLocked', self.ComputingUnitResetLocked, 'uint8', false, errs,
        need_convert)

    TComputingUnitResetLocked:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComputingUnitResetLocked.proto_property, errs, need_convert)
    return self
end

function TComputingUnitResetLocked:unpack(_)
    return self.ComputingUnitResetLocked
end

MNpuBoard.ComputingUnitResetLocked = TComputingUnitResetLocked

---@class MNpuBoard.ComputingUnitReset
---@field ComputingUnitReset integer
local TComputingUnitReset = {}
TComputingUnitReset.__index = TComputingUnitReset
TComputingUnitReset.group = {}

local function TComputingUnitReset_from_obj(obj)
    return setmetatable(obj, TComputingUnitReset)
end

function TComputingUnitReset.new(ComputingUnitReset)
    return TComputingUnitReset_from_obj({ComputingUnitReset = ComputingUnitReset or 0})
end
---@param obj MNpuBoard.ComputingUnitReset
function TComputingUnitReset:init_from_obj(obj)
    self.ComputingUnitReset = obj.ComputingUnitReset or 0
end

function TComputingUnitReset:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComputingUnitReset.group)
end

TComputingUnitReset.from_obj = TComputingUnitReset_from_obj

TComputingUnitReset.proto_property = {'ComputingUnitReset'}

TComputingUnitReset.default = {0}

TComputingUnitReset.struct = {{name = 'ComputingUnitReset', is_array = false, struct = nil}}

function TComputingUnitReset:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComputingUnitReset', self.ComputingUnitReset, 'uint8', false, errs, need_convert)

    TComputingUnitReset:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComputingUnitReset.proto_property, errs, need_convert)
    return self
end

function TComputingUnitReset:unpack(_)
    return self.ComputingUnitReset
end

MNpuBoard.ComputingUnitReset = TComputingUnitReset

---@class MNpuBoard.GlobalResetLocked
---@field GlobalResetLocked integer
local TGlobalResetLocked = {}
TGlobalResetLocked.__index = TGlobalResetLocked
TGlobalResetLocked.group = {}

local function TGlobalResetLocked_from_obj(obj)
    return setmetatable(obj, TGlobalResetLocked)
end

function TGlobalResetLocked.new(GlobalResetLocked)
    return TGlobalResetLocked_from_obj({GlobalResetLocked = GlobalResetLocked or 0})
end
---@param obj MNpuBoard.GlobalResetLocked
function TGlobalResetLocked:init_from_obj(obj)
    self.GlobalResetLocked = obj.GlobalResetLocked or 0
end

function TGlobalResetLocked:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGlobalResetLocked.group)
end

TGlobalResetLocked.from_obj = TGlobalResetLocked_from_obj

TGlobalResetLocked.proto_property = {'GlobalResetLocked'}

TGlobalResetLocked.default = {0}

TGlobalResetLocked.struct = {{name = 'GlobalResetLocked', is_array = false, struct = nil}}

function TGlobalResetLocked:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GlobalResetLocked', self.GlobalResetLocked, 'uint8', false, errs, need_convert)

    TGlobalResetLocked:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGlobalResetLocked.proto_property, errs, need_convert)
    return self
end

function TGlobalResetLocked:unpack(_)
    return self.GlobalResetLocked
end

MNpuBoard.GlobalResetLocked = TGlobalResetLocked

---@class MNpuBoard.GlobalReset
---@field GlobalReset integer
local TGlobalReset = {}
TGlobalReset.__index = TGlobalReset
TGlobalReset.group = {}

local function TGlobalReset_from_obj(obj)
    return setmetatable(obj, TGlobalReset)
end

function TGlobalReset.new(GlobalReset)
    return TGlobalReset_from_obj({GlobalReset = GlobalReset or 0})
end
---@param obj MNpuBoard.GlobalReset
function TGlobalReset:init_from_obj(obj)
    self.GlobalReset = obj.GlobalReset or 0
end

function TGlobalReset:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGlobalReset.group)
end

TGlobalReset.from_obj = TGlobalReset_from_obj

TGlobalReset.proto_property = {'GlobalReset'}

TGlobalReset.default = {0}

TGlobalReset.struct = {{name = 'GlobalReset', is_array = false, struct = nil}}

function TGlobalReset:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GlobalReset', self.GlobalReset, 'uint8', false, errs, need_convert)

    TGlobalReset:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGlobalReset.proto_property, errs, need_convert)
    return self
end

function TGlobalReset:unpack(_)
    return self.GlobalReset
end

MNpuBoard.GlobalReset = TGlobalReset

---@class MNpuBoard.BusType
---@field BusType integer
local TBusType = {}
TBusType.__index = TBusType
TBusType.group = {}

local function TBusType_from_obj(obj)
    return setmetatable(obj, TBusType)
end

function TBusType.new(BusType)
    return TBusType_from_obj({BusType = BusType or 0})
end
---@param obj MNpuBoard.BusType
function TBusType:init_from_obj(obj)
    self.BusType = obj.BusType or 0
end

function TBusType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBusType.group)
end

TBusType.from_obj = TBusType_from_obj

TBusType.proto_property = {'BusType'}

TBusType.default = {0}

TBusType.struct = {{name = 'BusType', is_array = false, struct = nil}}

function TBusType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BusType', self.BusType, 'uint8', false, errs, need_convert)

    TBusType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBusType.proto_property, errs, need_convert)
    return self
end

function TBusType:unpack(_)
    return self.BusType
end

MNpuBoard.BusType = TBusType

---@class MNpuBoard.CollectMCULogFlag
---@field CollectMCULogFlag integer
local TCollectMCULogFlag = {}
TCollectMCULogFlag.__index = TCollectMCULogFlag
TCollectMCULogFlag.group = {}

local function TCollectMCULogFlag_from_obj(obj)
    return setmetatable(obj, TCollectMCULogFlag)
end

function TCollectMCULogFlag.new(CollectMCULogFlag)
    return TCollectMCULogFlag_from_obj({CollectMCULogFlag = CollectMCULogFlag or 0})
end
---@param obj MNpuBoard.CollectMCULogFlag
function TCollectMCULogFlag:init_from_obj(obj)
    self.CollectMCULogFlag = obj.CollectMCULogFlag or 0
end

function TCollectMCULogFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCollectMCULogFlag.group)
end

TCollectMCULogFlag.from_obj = TCollectMCULogFlag_from_obj

TCollectMCULogFlag.proto_property = {'CollectMCULogFlag'}

TCollectMCULogFlag.default = {0}

TCollectMCULogFlag.struct = {{name = 'CollectMCULogFlag', is_array = false, struct = nil}}

function TCollectMCULogFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CollectMCULogFlag', self.CollectMCULogFlag, 'uint8', false, errs, need_convert)

    TCollectMCULogFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCollectMCULogFlag.proto_property, errs, need_convert)
    return self
end

function TCollectMCULogFlag:unpack(_)
    return self.CollectMCULogFlag
end

MNpuBoard.CollectMCULogFlag = TCollectMCULogFlag

---@class MNpuBoard.Reset
---@field Reset integer
local TReset = {}
TReset.__index = TReset
TReset.group = {}

local function TReset_from_obj(obj)
    return setmetatable(obj, TReset)
end

function TReset.new(Reset)
    return TReset_from_obj({Reset = Reset})
end
---@param obj MNpuBoard.Reset
function TReset:init_from_obj(obj)
    self.Reset = obj.Reset
end

function TReset:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReset.group)
end

TReset.from_obj = TReset_from_obj

TReset.proto_property = {'Reset'}

TReset.default = {0}

TReset.struct = {{name = 'Reset', is_array = false, struct = nil}}

function TReset:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reset', self.Reset, 'uint32', false, errs, need_convert)

    TReset:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReset.proto_property, errs, need_convert)
    return self
end

function TReset:unpack(_)
    return self.Reset
end

MNpuBoard.Reset = TReset

---@class MNpuBoard.CpldTestNum
---@field CpldTestNum integer
local TCpldTestNum = {}
TCpldTestNum.__index = TCpldTestNum
TCpldTestNum.group = {}

local function TCpldTestNum_from_obj(obj)
    return setmetatable(obj, TCpldTestNum)
end

function TCpldTestNum.new(CpldTestNum)
    return TCpldTestNum_from_obj({CpldTestNum = CpldTestNum or 1})
end
---@param obj MNpuBoard.CpldTestNum
function TCpldTestNum:init_from_obj(obj)
    self.CpldTestNum = obj.CpldTestNum or 1
end

function TCpldTestNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldTestNum.group)
end

TCpldTestNum.from_obj = TCpldTestNum_from_obj

TCpldTestNum.proto_property = {'CpldTestNum'}

TCpldTestNum.default = {0}

TCpldTestNum.struct = {{name = 'CpldTestNum', is_array = false, struct = nil}}

function TCpldTestNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldTestNum', self.CpldTestNum, 'uint8', false, errs, need_convert)

    TCpldTestNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldTestNum.proto_property, errs, need_convert)
    return self
end

function TCpldTestNum:unpack(_)
    return self.CpldTestNum
end

MNpuBoard.CpldTestNum = TCpldTestNum

---@class MNpuBoard.Count
---@field Count integer
local TCount = {}
TCount.__index = TCount
TCount.group = {}

local function TCount_from_obj(obj)
    return setmetatable(obj, TCount)
end

function TCount.new(Count)
    return TCount_from_obj({Count = Count or 0})
end
---@param obj MNpuBoard.Count
function TCount:init_from_obj(obj)
    self.Count = obj.Count or 0
end

function TCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCount.group)
end

TCount.from_obj = TCount_from_obj

TCount.proto_property = {'Count'}

TCount.default = {0}

TCount.struct = {{name = 'Count', is_array = false, struct = nil}}

function TCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)

    TCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCount.proto_property, errs, need_convert)
    return self
end

function TCount:unpack(_)
    return self.Count
end

MNpuBoard.Count = TCount

---@class MNpuBoard.CpldTestReg
---@field CpldTestReg integer
local TCpldTestReg = {}
TCpldTestReg.__index = TCpldTestReg
TCpldTestReg.group = {}

local function TCpldTestReg_from_obj(obj)
    return setmetatable(obj, TCpldTestReg)
end

function TCpldTestReg.new(CpldTestReg)
    return TCpldTestReg_from_obj({CpldTestReg = CpldTestReg})
end
---@param obj MNpuBoard.CpldTestReg
function TCpldTestReg:init_from_obj(obj)
    self.CpldTestReg = obj.CpldTestReg
end

function TCpldTestReg:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpldTestReg.group)
end

TCpldTestReg.from_obj = TCpldTestReg_from_obj

TCpldTestReg.proto_property = {'CpldTestReg'}

TCpldTestReg.default = {0}

TCpldTestReg.struct = {{name = 'CpldTestReg', is_array = false, struct = nil}}

function TCpldTestReg:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpldTestReg', self.CpldTestReg, 'uint32', false, errs, need_convert)

    TCpldTestReg:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpldTestReg.proto_property, errs, need_convert)
    return self
end

function TCpldTestReg:unpack(_)
    return self.CpldTestReg
end

MNpuBoard.CpldTestReg = TCpldTestReg

---@class MNpuBoard.BmcStartFlag
---@field BmcStartFlag integer
local TBmcStartFlag = {}
TBmcStartFlag.__index = TBmcStartFlag
TBmcStartFlag.group = {}

local function TBmcStartFlag_from_obj(obj)
    return setmetatable(obj, TBmcStartFlag)
end

function TBmcStartFlag.new(BmcStartFlag)
    return TBmcStartFlag_from_obj({BmcStartFlag = BmcStartFlag})
end
---@param obj MNpuBoard.BmcStartFlag
function TBmcStartFlag:init_from_obj(obj)
    self.BmcStartFlag = obj.BmcStartFlag
end

function TBmcStartFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBmcStartFlag.group)
end

TBmcStartFlag.from_obj = TBmcStartFlag_from_obj

TBmcStartFlag.proto_property = {'BmcStartFlag'}

TBmcStartFlag.default = {0}

TBmcStartFlag.struct = {{name = 'BmcStartFlag', is_array = false, struct = nil}}

function TBmcStartFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BmcStartFlag', self.BmcStartFlag, 'uint8', false, errs, need_convert)

    TBmcStartFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBmcStartFlag.proto_property, errs, need_convert)
    return self
end

function TBmcStartFlag:unpack(_)
    return self.BmcStartFlag
end

MNpuBoard.BmcStartFlag = TBmcStartFlag

---@class MNpuBoard.Container
---@field Container string
local TContainer = {}
TContainer.__index = TContainer
TContainer.group = {}

local function TContainer_from_obj(obj)
    return setmetatable(obj, TContainer)
end

function TContainer.new(Container)
    return TContainer_from_obj({Container = Container})
end
---@param obj MNpuBoard.Container
function TContainer:init_from_obj(obj)
    self.Container = obj.Container
end

function TContainer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainer.group)
end

TContainer.from_obj = TContainer_from_obj

TContainer.proto_property = {'Container'}

TContainer.default = {''}

TContainer.struct = {{name = 'Container', is_array = false, struct = nil}}

function TContainer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Container', self.Container, 'string', false, errs, need_convert)

    TContainer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainer.proto_property, errs, need_convert)
    return self
end

function TContainer:unpack(_)
    return self.Container
end

MNpuBoard.Container = TContainer

---@class MNpuBoard.RefSMCChip
---@field RefSMCChip integer[]
local TRefSMCChip = {}
TRefSMCChip.__index = TRefSMCChip
TRefSMCChip.group = {}

local function TRefSMCChip_from_obj(obj)
    return setmetatable(obj, TRefSMCChip)
end

function TRefSMCChip.new(RefSMCChip)
    return TRefSMCChip_from_obj({RefSMCChip = RefSMCChip})
end
---@param obj MNpuBoard.RefSMCChip
function TRefSMCChip:init_from_obj(obj)
    self.RefSMCChip = obj.RefSMCChip
end

function TRefSMCChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefSMCChip.group)
end

TRefSMCChip.from_obj = TRefSMCChip_from_obj

TRefSMCChip.proto_property = {'RefSMCChip'}

TRefSMCChip.default = {{}}

TRefSMCChip.struct = {{name = 'RefSMCChip', is_array = true, struct = nil}}

function TRefSMCChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefSMCChip', self.RefSMCChip, 'uint8', false, errs, need_convert)

    TRefSMCChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefSMCChip.proto_property, errs, need_convert)
    return self
end

function TRefSMCChip:unpack(_)
    return self.RefSMCChip
end

MNpuBoard.RefSMCChip = TRefSMCChip

---@class MNpuBoard.RefMCUChip
---@field RefMCUChip integer[]
local TRefMCUChip = {}
TRefMCUChip.__index = TRefMCUChip
TRefMCUChip.group = {}

local function TRefMCUChip_from_obj(obj)
    return setmetatable(obj, TRefMCUChip)
end

function TRefMCUChip.new(RefMCUChip)
    return TRefMCUChip_from_obj({RefMCUChip = RefMCUChip})
end
---@param obj MNpuBoard.RefMCUChip
function TRefMCUChip:init_from_obj(obj)
    self.RefMCUChip = obj.RefMCUChip
end

function TRefMCUChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefMCUChip.group)
end

TRefMCUChip.from_obj = TRefMCUChip_from_obj

TRefMCUChip.proto_property = {'RefMCUChip'}

TRefMCUChip.default = {{}}

TRefMCUChip.struct = {{name = 'RefMCUChip', is_array = true, struct = nil}}

function TRefMCUChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefMCUChip', self.RefMCUChip, 'uint8', false, errs, need_convert)

    TRefMCUChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefMCUChip.proto_property, errs, need_convert)
    return self
end

function TRefMCUChip:unpack(_)
    return self.RefMCUChip
end

MNpuBoard.RefMCUChip = TRefMCUChip

---@class MNpuBoard.LogicVersionID
---@field LogicVersionID integer
local TLogicVersionID = {}
TLogicVersionID.__index = TLogicVersionID
TLogicVersionID.group = {}

local function TLogicVersionID_from_obj(obj)
    return setmetatable(obj, TLogicVersionID)
end

function TLogicVersionID.new(LogicVersionID)
    return TLogicVersionID_from_obj({LogicVersionID = LogicVersionID})
end
---@param obj MNpuBoard.LogicVersionID
function TLogicVersionID:init_from_obj(obj)
    self.LogicVersionID = obj.LogicVersionID
end

function TLogicVersionID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicVersionID.group)
end

TLogicVersionID.from_obj = TLogicVersionID_from_obj

TLogicVersionID.proto_property = {'LogicVersionID'}

TLogicVersionID.default = {0}

TLogicVersionID.struct = {{name = 'LogicVersionID', is_array = false, struct = nil}}

function TLogicVersionID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicVersionID', self.LogicVersionID, 'uint8', false, errs, need_convert)

    TLogicVersionID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicVersionID.proto_property, errs, need_convert)
    return self
end

function TLogicVersionID:unpack(_)
    return self.LogicVersionID
end

MNpuBoard.LogicVersionID = TLogicVersionID

---@class MNpuBoard.PcbID
---@field PcbID integer
local TPcbID = {}
TPcbID.__index = TPcbID
TPcbID.group = {}

local function TPcbID_from_obj(obj)
    return setmetatable(obj, TPcbID)
end

function TPcbID.new(PcbID)
    return TPcbID_from_obj({PcbID = PcbID})
end
---@param obj MNpuBoard.PcbID
function TPcbID:init_from_obj(obj)
    self.PcbID = obj.PcbID
end

function TPcbID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcbID.group)
end

TPcbID.from_obj = TPcbID_from_obj

TPcbID.proto_property = {'PcbID'}

TPcbID.default = {0}

TPcbID.struct = {{name = 'PcbID', is_array = false, struct = nil}}

function TPcbID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PcbID', self.PcbID, 'uint8', false, errs, need_convert)

    TPcbID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcbID.proto_property, errs, need_convert)
    return self
end

function TPcbID:unpack(_)
    return self.PcbID
end

MNpuBoard.PcbID = TPcbID

return MNpuBoard
